package com.artfess.manage.safty.model;


import com.artfess.base.entity.BaseModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.math.BigDecimal;
import java.time.LocalDate;

/**
 * 安全目标考核-指标项评分(CmgtSaftyCheckItem)表实体类
 *
 * @author 黎沐华
 * @since 2023-05-05 09:23:15
 */
@Data
@TableName("CMGT_SAFTY_CHECK_ITEM")
@ApiModel("安全目标考核-指标项评分(CmgtSaftyCheckItem)表实体类")
public class CmgtSaftyCheckItem extends BaseModel<CmgtSaftyCheckItem> {

    @NotNull(message = "修改必须指定id", groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id", groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @NotNull(message = "修改时必须指定 目标考核ID", groups = {UpdateGroup.class})
    @ApiModelProperty("目标考核_ID")
    @TableField("info_id_")
    private String infoId;

    @NotNull(message = "必须指定 考核指标项目ID", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty("考核指标项_ID")
    @TableField("item_id_")
    private String itemId;

    @ApiModelProperty("考核指标项名称")
    @TableField("item_name_")
    private String itemName;

    @ApiModelProperty("考核指标项标准说明")
    @TableField("item_stand_")
    private String itemStand;

    @ApiModelProperty("考核项评分（1--100）")
    @TableField("item_score_")
    private Integer itemScore;

    @ApiModelProperty("考核项得分(评分*权重)")
    @TableField("item_result_")
    private BigDecimal itemResult;

    @ApiModelProperty(value = "数据时间戳")
    @TableField("last_time_")
    private LocalDate lastTime;

}

