package com.artfess.manage.safty.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.manage.safty.manager.CmgtSaftyDangerCheckrecordManager;
import com.artfess.manage.safty.manager.dto.CmgtSaftyDangerCheckrecordDto;
import com.artfess.manage.safty.manager.mapper.CmgtSaftyDangerCheckrecordDtoMapper;
import com.artfess.manage.safty.model.CmgtSaftyDangerCheckrecord;
import com.artfess.rocketmq.producer.RocketMQProducer;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;

/**
 * 安全隐患排查记录 前端控制器
 *
 * @author wujl
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-08-01
 */
@Slf4j
@Api(tags = "安全隐患排查记录")
@RestController
@RequestMapping("/manager/cmgtSaftyDangerCheckrecord")
@ApiGroup(group = {ApiGroupConsts.MANAGER_BIZ})
public class CmgtSaftyDangerCheckrecordController extends BaseController<CmgtSaftyDangerCheckrecordManager, CmgtSaftyDangerCheckrecord> {

    @Autowired
    private CmgtSaftyDangerCheckrecordManager cmgtSaftyDangerCheckrecordManager;

    @Resource
    private CmgtSaftyDangerCheckrecordDtoMapper checkrecordDtoMapper;

    @Resource
    private RocketMQProducer rocketMQProducer;

    @PostMapping(value = "/pageQuery", produces = {"application/json; charset=utf-8"})
    @ApiOperation("分页查询")
    public PageList<CmgtSaftyDangerCheckrecordDto> pageQuery(@ApiParam(name = "queryFilter", value = "分页查询信息") @RequestBody QueryFilter<CmgtSaftyDangerCheckrecord> queryFilter) {
//        rocketMQProducer.send("dutydanger", JSONUtil.createObj()
//                .putOpt("type", "danger")
//                .putOpt("content", "小微隐患")
//                .toStringPretty());
        return cmgtSaftyDangerCheckrecordManager.pageQuery(queryFilter);
    }


    @PostMapping("/add")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({AddGroup.class}) CmgtSaftyDangerCheckrecordDto t) {
        String result = cmgtSaftyDangerCheckrecordManager.createInfo(checkrecordDtoMapper.toEntity(t));
        if (StringUtil.isEmpty(result)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }


    @PutMapping("/update")
    @ApiOperation("更新实体")
    public CommonResult<String> updateById(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({UpdateGroup.class}) CmgtSaftyDangerCheckrecordDto t) {
        String result = cmgtSaftyDangerCheckrecordManager.updateInfo(checkrecordDtoMapper.toEntity(t));
        if (StringUtil.isEmpty(result)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新实体失败");
        }
        return new CommonResult<>();
    }

    @PostMapping("/closeDanger")
    @ApiOperation("关闭隐患")
    public CommonResult<String> closeDanger(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({AddGroup.class}) CmgtSaftyDangerCheckrecordDto t) {
        CmgtSaftyDangerCheckrecord dc = cmgtSaftyDangerCheckrecordManager.get(t.getId());
        dc.setStatus(t.getStatus());
        dc.setMemo(t.getMemo());
        String result = cmgtSaftyDangerCheckrecordManager.updateInfo(dc);
        if (StringUtil.isEmpty(result)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

}
