package com.artfess.manage.material.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.enums.CodePrefix;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.manage.material.dao.CmgtMaterialPurchasingDao;
import com.artfess.manage.material.manager.CmgtMaterialInfoManager;
import com.artfess.manage.material.manager.CmgtMaterialPurchasingDetailManager;
import com.artfess.manage.material.manager.CmgtMaterialPurchasingManager;
import com.artfess.manage.material.manager.CmgtMaterialQuantityManage;
import com.artfess.manage.material.model.CmgtMaterialFlowLog;
import com.artfess.manage.material.model.CmgtMaterialInfo;
import com.artfess.manage.material.model.CmgtMaterialOrderDetail;
import com.artfess.manage.material.model.CmgtMaterialOrderSupplier;
import com.artfess.manage.material.model.CmgtMaterialPurchasing;
import com.artfess.manage.material.model.CmgtMaterialPurchasingDetail;
import com.artfess.manage.material.model.CmgtMaterialQuantity;
import com.artfess.manage.material.model.CmgtMaterialSignWarehouse;
import com.artfess.manage.material.model.CmgtMaterialSignWarehouseDetail;
import com.artfess.redis.util.CodeCreatorUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.api.client.util.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;

/**
 * 物资采购申请 服务实现类
 *
 * @author wujl
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-07-23
 */
@Service
@Transactional(readOnly = true)
public class CmgtMaterialPurchasingManagerImpl extends BaseManagerImpl<CmgtMaterialPurchasingDao, CmgtMaterialPurchasing> implements CmgtMaterialPurchasingManager {

    @Resource
    private CmgtMaterialPurchasingDao cmgtMaterialPurchasingDao;

    @Resource
    private CmgtMaterialPurchasingDetailManager cmgtMaterialPurchasingDetailManager;

    @Autowired
    private CmgtMaterialQuantityManage quantityManage;

    @Resource
    private BaseContext baseContext;

    @Resource
    private CodeCreatorUtil codeCreatorUtil;


    @Override
    @Transactional(readOnly = false)
    public Boolean deleteById(String id) {
        return cmgtMaterialPurchasingDao.deleteById(id);
    }


    @Override
    @Transactional
    public String createInfo(CmgtMaterialPurchasing t) {
        t.setStatus("1");
        String code = codeCreatorUtil.createCodeYYYYMMDD(CodePrefix.PURCHASING, 12);
        t.setCode(code);
        int i = this.baseMapper.insert(t);
        //保存明细
        if (i > 0) {
            processDetailList(t);
            return t.getId();
        }
        return null;
    }

    private void processDetailList(CmgtMaterialPurchasing t) {


        QueryWrapper<CmgtMaterialPurchasingDetail> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("PURCHASING_ID_", t.getId());
        cmgtMaterialPurchasingDetailManager.remove(queryWrapper);
        if (CollectionUtils.isEmpty(t.getDetailList())) {
            return;
        }

        t.getDetailList().forEach(detail -> {
            //单项金额
            detail.setPurchasingId(t.getId());
        });
        cmgtMaterialPurchasingDetailManager.saveOrUpdateBatch(t.getDetailList());
    }

    @Override
    @Transactional
    public String updateInfo(CmgtMaterialPurchasing t) {
        CmgtMaterialPurchasing cmgtMaterialPurchasing = baseMapper.selectById(t.getId());
        if (null == cmgtMaterialPurchasing) {
            throw new BaseException("申请单不存在");
        }
        t.setStatus(cmgtMaterialPurchasing.getStatus());
        t.setCode(cmgtMaterialPurchasing.getCode());
        int i = this.baseMapper.updateById(t);
        if (i > 0) {
            processDetailList(t);
            return t.getId();
        }
        return null;
    }

    @Override
    public List<CmgtMaterialPurchasingDetail> detailList(List<String> ids) {

        return this.baseMapper.detailList(ids);
    }

    @Override
    @Transactional(readOnly = false)
    public boolean updateStatus(CmgtMaterialPurchasing t) {
        CmgtMaterialPurchasing cmgtMaterialPurchasing = baseMapper.selectById(t.getId());
        if (null == cmgtMaterialPurchasing) {
            return false;
        }
        cmgtMaterialPurchasing.setStatus("2");
        int i = this.baseMapper.updateById(cmgtMaterialPurchasing);
        if (i > 0) {
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean recipients(CmgtMaterialPurchasing t) {
        List<CmgtMaterialFlowLog> logList = com.google.api.client.util.Lists.newArrayList();
        List<CmgtMaterialQuantity> quantityList = Lists.newArrayList();
        t.getDetailList().forEach(detail -> {
            createLogs(t, logList, quantityList, detail);
        });
        t.setStatus("3");
        int i = this.baseMapper.updateById(t);
        if(i > 0){
            return true;
        }
        return false;
    }

    @Override
    public List<CmgtMaterialPurchasingDetail> recipientsMaterialList(List<String> ids) {
        List<CmgtMaterialPurchasingDetail> cmgtMaterialPurchasingDetails = this.baseMapper.recipientsMaterialList(ids);
        cmgtMaterialPurchasingDetails.forEach(detail -> {
            detail.setAmount(detail.getPrice().multiply(detail.getQuantity()));
        });
        return cmgtMaterialPurchasingDetails;
    }

    private void createLogs(CmgtMaterialPurchasing t,
                            List<CmgtMaterialFlowLog> logList,
                            List<CmgtMaterialQuantity> quantityList,
                            CmgtMaterialPurchasingDetail detail) {
        //1、更新库存 2、记录入库日志
        CmgtMaterialFlowLog log = new CmgtMaterialFlowLog();
        log.setInoutType("2");
        log.setInoutId(t.getId());
        log.setMaterialId(detail.getMaterialInfoId());
        log.setMaterialName(detail.getName());
        log.setModel(detail.getModel());
        log.setUnit(detail.getUnit());
        log.setWarehouse(detail.getWarehouse());
        log.setQuantity(detail.getQuantity());
        log.setForTheDate(LocalDateTime.now());
        log.setFortheOrg(baseContext.getCurrentOrgName());
        log.setFortheUser(baseContext.getCurrentUserName());
        logList.add(log);

        QueryWrapper<CmgtMaterialQuantity> quantityQueryWrapper = new QueryWrapper<>();
        quantityQueryWrapper.eq("WAREHOUSE_", detail.getWarehouse());
        quantityQueryWrapper.eq("material_id_", detail.getMaterialInfoId());
        CmgtMaterialQuantity cmgtMaterialQuantity = this.quantityManage.getBaseMapper().selectOne(quantityQueryWrapper);
        if (null == cmgtMaterialQuantity) {
            throw new BaseException("当前物资暂无库存，无法完成领用");
        } else {
            if(cmgtMaterialQuantity.getQuantity().compareTo(detail.getQuantity()) == -1) {
                throw new BaseException("当前物资暂无库存，无法完成领用");
            }
            cmgtMaterialQuantity.setQuantity(cmgtMaterialQuantity.getQuantity().subtract(detail.getQuantity()));
            cmgtMaterialQuantity.setAmount(cmgtMaterialQuantity.getAmount().subtract(detail.getAmount()));
        }
        quantityList.add(cmgtMaterialQuantity);
    }

}
