package com.artfess.manage.material.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.manage.material.manager.CmgtMaterialPurchasingManager;
import com.artfess.manage.material.manager.CmgtMaterialQuantityManage;
import com.artfess.manage.material.model.CmgtMaterialFlowLog;
import com.artfess.manage.material.dao.CmgtMaterialFlowLogDao;
import com.artfess.manage.material.manager.CmgtMaterialFlowLogManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.manage.material.model.CmgtMaterialPurchasing;
import com.artfess.manage.material.model.CmgtMaterialQuantity;
import com.artfess.manage.material.vo.RecipientsVo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 物资产品-库存流水记录表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2023-04-24
 */
@Service
public class CmgtMaterialFlowLogManagerImpl extends BaseManagerImpl<CmgtMaterialFlowLogDao, CmgtMaterialFlowLog> implements CmgtMaterialFlowLogManager {

    @Autowired
    private CmgtMaterialPurchasingManager purchasingManager;

    @Autowired
    private CmgtMaterialQuantityManage quantityManage;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean recipients(RecipientsVo t) {
        Assert.hasText(t.getPurchasingId(), "请选择领用单");
        CmgtMaterialPurchasing cmgtMaterialPurchasing = purchasingManager.get(t.getPurchasingId());
        Assert.notNull(cmgtMaterialPurchasing, "领用单不存在");
        if(!"2".equals(cmgtMaterialPurchasing.getApplyType())){
            throw new BaseException("请确认该申请单是否为领用申请单");
        }
        if("1".equals(cmgtMaterialPurchasing.getStatus()) || "3".equals(cmgtMaterialPurchasing.getStatus()) ){
            throw new BaseException("该申请单不满足领用条件，请检查申请单是否已确认或者已完全出库");
        }

        Assert.notEmpty(t.getList(),"请选择要领用的物资");
        List<CmgtMaterialFlowLog> list = t.getList();
        List<CmgtMaterialQuantity> quantityList = Lists.newArrayList();
        list.forEach(detail->{
            //1、更新库存 2、记录入库日志
            detail.setInoutType("2");
            detail.setInoutId(t.getPurchasingId());
            detail.setForTheDate(LocalDateTime.now());
            detail.setWarehouse(t.getWarehouse());
            QueryWrapper<CmgtMaterialQuantity> quantityQueryWrapper = new QueryWrapper<>();
            quantityQueryWrapper.eq("WAREHOUSE_", t.getWarehouse());
            quantityQueryWrapper.eq("material_id_", detail.getMaterialId());
            CmgtMaterialQuantity cmgtMaterialQuantity = this.quantityManage.getBaseMapper().selectOne(quantityQueryWrapper);
            if (null == cmgtMaterialQuantity || cmgtMaterialQuantity.getQuantity().compareTo(detail.getQuantity()) == -1) {
                throw new BaseException("当前物资暂无库存，无法完成领用");
            } else {
                cmgtMaterialQuantity.setQuantity(cmgtMaterialQuantity.getQuantity().subtract(detail.getQuantity()));
                cmgtMaterialQuantity.setAmount(cmgtMaterialQuantity.getAmount().subtract(detail.getAmount()));
            }
            quantityList.add(cmgtMaterialQuantity);
        });

        quantityManage.updateBatchById(quantityList);
        this.saveBatch(list);

        return true;
    }
}
