package com.artfess.manage.dwd.manager.dto;

import com.artfess.manage.base.ManageBaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;




/**
 * dwd_sj_weather_pheno_mi
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-21
 */
@Data
@ApiModel(value="DwdSjWeatherPhenoMiDto", description="来自互联网心知天气的天气现象DTO对象")
public class DwdSjWeatherPhenoMiDto extends ManageBaseModel<DwdSjWeatherPhenoMiDto> {


    /** id */
    @ApiModelProperty(value = "主键_ID")
    private String id;




    /** 地区 */
    @ApiModelProperty(value = "地区")
    private String name;




    /** 路径 */
    @ApiModelProperty(value = "路径")
    private String path;




    /** 时区 */
    @ApiModelProperty(value = "时区")
    private String timezone;




    /** 时区偏移 */
    @ApiModelProperty(value = "时区偏移")
    private String timezoneOffset;




    /** 天气现象 */
    @ApiModelProperty(value = "天气现象")
    private String text;




    /** 天气现象编码 */
    @ApiModelProperty(value = "天气现象编码")
    private String code;




    /** 温度 */
    @ApiModelProperty(value = "温度")
    private String temperature;




    /** 来源更新时间 */
    @ApiModelProperty(value = "来源更新时间")
    private String lastUpdate;




    /** 中台插入时间 */
    @ApiModelProperty(value = "中台插入时间")
    private String insertTime;


    /** 接收ID */
    @ApiModelProperty(value = "接收ID")
    private String areaId;


    private String createByName;

}
