package com.artfess.manage.duty.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;

/**
 * cmgt_duty_org_workarrange
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wujl
 * @since 2022-08-11
 */
@Data
@ApiModel(value="CmgtDutyOrgWorkarrange对象", description="部门排班信息")
//@FieldRepeat(fields = {"code","name"},message = "名称不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class CmgtDutyOrgWorkarrange extends AutoFillModel<CmgtDutyOrgWorkarrange> {


    /** 主键_ID */
    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    /** 排班名称 */
    @ApiModelProperty(value = "排班名称")
    @TableField("name_")
    @NotBlank(message = "排班名称",groups = {AddGroup.class,UpdateGroup.class})
    private String name;

    /** 排班小组 */
    @ApiModelProperty(value = "排班小组")
    @TableField("team_id__")
    private String teamId;

    /** 归属部门 */
    @ApiModelProperty(value = "归属部门")
    @TableField("org_id_")
    private String orgId;

    /** 排序 */
    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    /** 备注 */
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    /** 删除标识，1已删除，0未删除 */
    @ApiModelProperty(value = "删除标识，1已删除，0未删除")
    @TableField("is_dele_")
    private String isDele;

    /** 版本号 */
    @ApiModelProperty(value = "版本号")
    @TableField("version_")
    private Integer version;

    /** 数据时间戳 */
    @ApiModelProperty(value = "数据时间戳")
    @TableField("last_time_")
    private LocalDateTime lastTime;

}
