package com.artfess.manage.duty.manager.impl;

import cn.hutool.core.lang.tree.Tree;
import cn.hutool.core.lang.tree.TreeNode;
import cn.hutool.core.lang.tree.TreeUtil;
import cn.hutool.json.JSONUtil;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.manage.base.ManageCommonService;
import com.artfess.manage.duty.CmgtDutySelectOptions;
import com.artfess.manage.duty.dao.CmgtDutyTeamMemberDao;
import com.artfess.manage.duty.manager.dto.CmgtDutyTeamDto;
import com.artfess.manage.duty.manager.mapper.CmgtDutyTeamDtoMapper;
import com.artfess.manage.duty.model.CmgtDutyTeam;
import com.artfess.manage.duty.dao.CmgtDutyTeamDao;
import com.artfess.manage.duty.manager.CmgtDutyTeamManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.manage.duty.model.CmgtDutyTeamMember;
import com.artfess.uc.model.Org;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 勤务小组信息 服务实现类
 *
 * @author wjl
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-07-20
 */
@Service
public class CmgtDutyTeamManagerImpl extends BaseManagerImpl<CmgtDutyTeamDao, CmgtDutyTeam> implements CmgtDutyTeamManager {

    @Resource
    CmgtDutyTeamDao cmgtDutyTeamDao;

    @Resource
    CmgtDutyTeamMemberDao cmgtDutyTeamMemberDao;

    @Resource
    ManageCommonService manageCommonService;

    @Resource
    CmgtDutyTeamDtoMapper cmgtDutyTeamDtoMapper;

    @Override
    public List<CmgtDutyTeam> findAllTeam() {
        return cmgtDutyTeamDao.selectByMap(new HashMap<>());
    }


    @Override
    public PageList<CmgtDutyTeamDto> pageQuery(QueryFilter<CmgtDutyTeam> queryFilter) {
        PageList<CmgtDutyTeam> result = query(queryFilter);
        PageList<CmgtDutyTeamDto> r = new PageList<CmgtDutyTeamDto>(
                result.getRows().stream().map(e -> {
                            CmgtDutyTeamDto t = cmgtDutyTeamDtoMapper.toDto(e);
                            return t;
                        }
                ).collect(Collectors.toList())
        );
        r.setPageSize(result.getPageSize());
        r.setPageSize(result.getPage());
        return r;
    }


    @Override
    public List<Tree<String>> findOrgTeamTreeData() {
        List<TreeNode<String>> r = new ArrayList<>();
        manageCommonService.getAllOrgTreeNodeList().forEach(o -> {
            //TreeNode<String> t = new TreeNode(o.getId(), o.getParentId(), o.getName(), (o.getWeight() != null ? o.getWeight().intValue() : 999));
            o.setExtra(JSONUtil.createObj().putOpt("dataType", "ORG"));
            r.add(o);
            r.addAll(this.findByOrgId(o.getId()).stream().map(team -> {
                TreeNode<String> k = new TreeNode(team.getId(), o.getId(), team.getName(), (team.getSn() != null ? team.getSn().intValue() : 999));
                k.setExtra(JSONUtil.createObj().putOpt("dataType", "TEAM"));
                return k;
            }).collect(Collectors.toList()));
        });
        List<Tree<String>> trees = TreeUtil.build(r, ManageCommonService.orgRoot);
        return trees;
    }


    /**
     * @param orgId
     * @return
     */
    public List<CmgtDutyTeam> findByOrgId(String orgId) {
        QueryWrapper<CmgtDutyTeam> queryWrapper = new QueryWrapper();
        queryWrapper.eq("org_id_", orgId);
        return cmgtDutyTeamDao.selectList(queryWrapper);
    }



    /**
     * @param orgId
     * @return
     */
    public List<CmgtDutyTeamMember> findTeamMemberByOrgId(String orgId) {
        if (StringUtil.isEmpty(orgId)) {
            return cmgtDutyTeamMemberDao.selectList(null);
        }
        QueryWrapper<CmgtDutyTeamMember> queryWrapper = new QueryWrapper();
//        List<String> orgs = findByOrgId(orgId).stream().map(t -> t.getId()).collect(Collectors.toList());
//        if (orgs.size() == 0) {
//            return new ArrayList<CmgtDutyTeamMember>();
//        }
//        queryWrapper.in("TEAM_ID_", orgs.toArray());
        queryWrapper.eq("ORG_ID_", orgId);
        return cmgtDutyTeamMemberDao.selectList(queryWrapper);
    }

    /**
     * @param teamId
     * @return
     */
    public List<CmgtDutyTeamMember> findTeamMemberByTeamId(String teamId) {
        QueryWrapper<CmgtDutyTeamMember> queryWrapper = new QueryWrapper();
        queryWrapper.in("TEAM_ID_", teamId);
        return cmgtDutyTeamMemberDao.selectList(queryWrapper).stream().map(t->{
            return t;
        }).collect(Collectors.toList());
    }



}
