package com.artfess.manage.duty.controller;


import cn.hutool.json.JSONObject;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.manage.duty.manager.CmgtDutyTeamManager;
import com.artfess.manage.duty.manager.CmgtDutyTeamMemberManager;
import com.artfess.manage.duty.manager.CmgtDutyWorkarrangeManager;
import com.artfess.manage.duty.manager.CmgtDutyWorkclassManager;
import com.artfess.manage.duty.manager.dto.CmgtDutyWorkarrangeDto;
import com.artfess.manage.duty.model.CmgtDutyTeam;
import com.artfess.manage.duty.model.CmgtDutyTeamMember;
import com.artfess.manage.duty.model.CmgtDutyWorkarrange;
import com.artfess.manage.duty.model.CmgtDutyWorkclass;
import com.artfess.manage.duty.vo.WorkArrangeInfoVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;


/**
 * 排班信息 前端控制器
 *
 * @author wujl
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-07-28
 */
@Slf4j
@Api(tags = "排班信息")
@RestController
@RequestMapping("/manager/cmgtDutyWorkarrange")
@ApiGroup(group = {ApiGroupConsts.MANAGER_BIZ})
public class CmgtDutyWorkarrangeController extends BaseController<CmgtDutyWorkarrangeManager, CmgtDutyWorkarrange> {

    @Autowired
    private CmgtDutyWorkclassManager workclassManager;

    @Autowired
    private CmgtDutyTeamMemberManager teamMemberManager;

    @Autowired
    private CmgtDutyTeamManager teamManager;

    @Autowired
    private CmgtDutyWorkarrangeManager cmgtDutyWorkarrange;


    @PostMapping("/add")
    @ApiOperation("新增排班信息")
    public CommonResult<String> create(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({AddGroup.class}) CmgtDutyWorkarrangeDto t) {
        // System.out.println("===========days===ttt=========" + t);
//        QueryFilter<CmgtDutyWorkarrange> filter = QueryFilter.build();
//        filter.addFilter("arrange_date_", t.getArrangeDate(), QueryOP.EQUAL);
//        filter.addFilter("workclass_id_", t.getWorkclassId(), QueryOP.EQUAL);
//        filter.addFilter("org_id_", t.getOrgId(), QueryOP.EQUAL);
//        List<CmgtDutyWorkarrange> list = cmgtDutyWorkarrange.queryNoPage(filter);
//        if (list != null && list.size() > 0) {
//            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "该班已存在，不能重复排班！");
//        }
        cmgtDutyWorkarrange.saveInfo(t, true);
        return new CommonResult<>();
    }

    @PutMapping("/update")
    @ApiOperation("更新实体")
    public CommonResult<String> updateById(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({UpdateGroup.class}) CmgtDutyWorkarrangeDto t) {
//        String result = cmgtDutyWorkarrange.updateInfo(t);
//        if (StringUtil.isEmpty(result)) {
//            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新实体失败");
//        }
        cmgtDutyWorkarrange.saveInfo(t, false);
        return new CommonResult<>();
    }

    @PostMapping(value = "/query/team", produces = {"application/json; charset=utf-8"})
    @ApiOperation("根据orgId查询小组信息")
    public CommonResult<String> queryTeamByOrgId(@ApiParam(name = "model", value = "查询条件") @RequestBody QueryFilter<CmgtDutyTeam> filter) {
        List<CmgtDutyTeam> teams = teamManager.queryNoPage(filter);
        return CommonResult.success(teams, null);
    }

    @PostMapping(value = "/query/teamMember", produces = {"application/json; charset=utf-8"})
    @ApiOperation("根据orgId查询组员信息")
    public CommonResult<String> queryTeamMemberByOrgId(@ApiParam(name = "model", value = "查询条件") @RequestBody QueryFilter<CmgtDutyTeamMember> filter) {
        List<CmgtDutyTeamMember> teamMembers = teamMemberManager.queryNoPage(filter);
        return CommonResult.success(teamMembers, null);
    }

    @PostMapping(value = "/query/class", produces = {"application/json; charset=utf-8"})
    @ApiOperation("查询所有班种信息")
    public CommonResult<String> queryClassByOrgId(@RequestBody QueryFilter<CmgtDutyWorkclass> filter) {
        List<CmgtDutyWorkclass> classList = workclassManager.queryNoPage(filter);
        return CommonResult.success(classList, null);
    }

    @GetMapping(value = "/query/members", produces = {"application/json; charset=utf-8"})
    @ApiOperation("根据teamId查询人员信息")
    public CommonResult<String> queryMembers(@ApiParam(name = "model", value = "查询条件") @RequestParam String teamId, @RequestParam String orgId) {
        List<Map<String, Object>> mlist = new ArrayList<Map<String, Object>>();
        if (StringUtil.isNotEmpty(teamId)) {
            mlist.addAll(teamMemberManager.findAllMembersByTeamId(teamId));
        } else {
            if (StringUtil.isNotEmpty(orgId)) {
                mlist.addAll(teamMemberManager.findMembersUngroupedByOrgId(orgId));
            }
        }
        return CommonResult.success(mlist, null);
    }

    @PostMapping(value = "/query/fastWorkArrange", produces = {"application/json; charset=utf-8"})
    @ApiOperation("按照部门一键排班")
    public CommonResult<String> fastWorkArrange(@ApiParam(name = "model", value = "查询条件") @RequestBody Map<String, Object> params) {
        System.out.println(params.toString());
        boolean result = false;
        try {
            result = cmgtDutyWorkarrange.fastWorkarrange(params);
        } catch (Exception e) {
            e.printStackTrace();
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, e.getMessage());
        }
        return new CommonResult<>();
    }

    @PostMapping(value = "/query/findMonthArrangeInfo", produces = {"application/json; charset=utf-8"})
    @ApiOperation("查询每月排班信息")
    public CommonResult<String> query(@ApiParam(name = "model", value = "查询条件") @RequestBody Map<String, Object> params) {
        List<WorkArrangeInfoVo> all = cmgtDutyWorkarrange.findAllByMonth(params.get("date").toString(), params.get("orgId").toString());
        return CommonResult.success(all, null);
    }

    @PostMapping(value = "/query/findTeamMemberArrangeing", produces = {"application/json; charset=utf-8"})
    @ApiOperation("查询队员月度排班信息")
    public CommonResult<String> findTeamMemberArrangeing(@ApiParam(name = "model", value = "查询条件") @RequestBody Map<String, Object> params) {
        if (params.get("startDate") != null) {
            return CommonResult.success(
                    cmgtDutyWorkarrange.findTeamMemberArrangeing(params.get("startDate").toString(), params.get("endDate").toString(), params.get("teamMemberId").toString())
                    , null
            );
        } else {
            return CommonResult.success(cmgtDutyWorkarrange.findTeamMemberArrangeing(params.get("date").toString(), params.get("teamMemberId").toString()), null);
        }

    }


    @ApiOperation("按组导出排班信息")
    @PostMapping(value = "/export", produces = {"application/json; charset=utf-8"})
    public void exportExecl(HttpServletRequest request, HttpServletResponse response, @RequestBody String date) {
        cmgtDutyWorkarrange.exportExcel(request, response, date);
    }

    @ApiOperation("按人员导出排班信息")
    @PostMapping(value = "/exportmember", produces = {"application/json; charset=utf-8"})
    public void exportMemberArrangeExecl(HttpServletRequest request, HttpServletResponse response, @RequestBody String date) throws ParseException {
        cmgtDutyWorkarrange.exportMemberArrangeExcel(request, response, date);
    }

    @ApiOperation("查询在勤人员")
    @PostMapping(value = "/onDudyMember", produces = {"application/json; charset=utf-8"})
    public CommonResult<String> onDudyMember(@RequestBody JSONObject params) throws ParseException {
        System.out.println("========jobIds=============" + params);
        List<String> jobIds = null;
        if (!params.isNull("jobIds")) {
            jobIds = params.getJSONArray("jobIds").toList(String.class);
        }

        if (!params.isNull("rq")) {
            List<LocalDateTime> rqs = params.getJSONArray("rq").toList(LocalDateTime.class);
            return CommonResult.success(cmgtDutyWorkarrange.findHistoryDutyStaff(jobIds, rqs, params), null);
        } else {
            return CommonResult.success(cmgtDutyWorkarrange.findCurrentStaffOnDuty(jobIds), null);
        }
    }

}
