package com.artfess.manage.safty.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.base.ManageCommonService;
import com.artfess.manage.safty.dao.CmgtSaftyPlanTaskDao;
import com.artfess.manage.safty.manager.CmgtSaftyPlanTaskManager;
import com.artfess.manage.safty.manager.dto.CmgtSaftyPlanTaskDto;
import com.artfess.manage.safty.manager.mapper.CmgtSaftyPlanTaskDtoMapper;
import com.artfess.manage.safty.model.CmgtSaftyPlanTask;
import com.artfess.uc.dao.UserDao;
import com.artfess.uc.model.User;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;



/**
 * 安全计划任务 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-03
 */
@Service
public class CmgtSaftyPlanTaskManagerImpl extends BaseManagerImpl<CmgtSaftyPlanTaskDao, CmgtSaftyPlanTask> implements CmgtSaftyPlanTaskManager {

    @Resource
    private UserDao userDao;

    @Resource
    private CmgtSaftyPlanTaskDao cmgtSaftyPlanTaskDao;

    @Resource
    private CmgtSaftyPlanTaskDtoMapper cmgtSaftyPlanTaskDtoMapper ;

    @Resource
    private ManageCommonService manageCommonService;


    @Override
    public PageList<CmgtSaftyPlanTaskDto> pageQuery(QueryFilter<CmgtSaftyPlanTask> queryFilter) {
        PageList<CmgtSaftyPlanTask> result = query(queryFilter);
        PageList<CmgtSaftyPlanTaskDto> r = new PageList<CmgtSaftyPlanTaskDto>(
                result.getRows().stream().map(e -> {
                            CmgtSaftyPlanTaskDto t = cmgtSaftyPlanTaskDtoMapper.toDto(e);


                            if(e.getCreateBy()!=null){
                               User user = userDao.selectById(e.getCreateBy());
                               if(user!=null){
                                   t.setCreateByName(user.getFullname());
                               }
                            }

                            return t;
                        }
                ).collect(Collectors.toList())
        );
        r.setTotal(result.getTotal());
        r.setPage(result.getPage());
        r.setPageSize(result.getPageSize());
        return r;
    }

    @Override
    public String createInfo(CmgtSaftyPlanTask t) {
        int i = this.baseMapper.insert(t);
        if(i>0){
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(CmgtSaftyPlanTask t) {
        this.baseMapper.updateById(t);
        return t.getId();
    }

    @Override
    public void deleteInfo(CmgtSaftyPlanTask t) {
        this.baseMapper.deleteById(t.getId());
    }


    public String create(CmgtSaftyPlanTaskDto dto) {
        CmgtSaftyPlanTask t = cmgtSaftyPlanTaskDtoMapper.toEntity(dto);
        int i = this.baseMapper.insert(t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }


    public String update(CmgtSaftyPlanTaskDto dto) {
        CmgtSaftyPlanTask t = cmgtSaftyPlanTaskDtoMapper.toEntity(dto);
        this.baseMapper.updateById(t);


        return t.getId();
    }

    public boolean delete(List<String> ids) {
        for (String id : ids) {

            int count = this.baseMapper.deleteById(id);
            if (count == 0) {
                return false;
            }
        }
        return true;
    }



    /**
     *
     * @param planId
     * @return
     */
    public List<CmgtSaftyPlanTask> selectListByPlanId(String planId) {
        QueryWrapper<CmgtSaftyPlanTask> queryWrapper = new QueryWrapper();
        queryWrapper.eq("plan_id_", planId);
        return cmgtSaftyPlanTaskDao.selectList(queryWrapper);
    }

}
