package com.artfess.manage.duty.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.duty.dao.CmgtDutyVehicleDao;
import com.artfess.manage.duty.manager.CmgtDutyVehicleManager;
import com.artfess.manage.duty.model.CmgtDutyVehicle;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;

/**
 * 车辆信息 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wjl
 * @since 2022-07-20
 */
@Service
public class CmgtDutyVehicleManagerImpl extends BaseManagerImpl<CmgtDutyVehicleDao, CmgtDutyVehicle> implements CmgtDutyVehicleManager {

    @Resource
    private CmgtDutyVehicleDao cmgtDutyVehicleDao;


    @Override
    public PageList<CmgtDutyVehicle> pageQuery(QueryFilter<CmgtDutyVehicle> queryFilter) {
        PageBean pageBean = queryFilter.getPageBean();
        IPage<CmgtDutyVehicle> result = baseMapper.queryPage(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass()));
        return new PageList<CmgtDutyVehicle>(result);
    }

    @Override
    public String createInfo(CmgtDutyVehicle t) {
        int i = this.baseMapper.insert(t);
        if(i>0){
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(CmgtDutyVehicle t) {
        this.baseMapper.updateById(t);
        return t.getId();
    }

    @Override
    public void deleteInfo(CmgtDutyVehicle t) {
        this.baseMapper.deleteById(t.getId());
    }
}
