package com.artfess.device.base.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.device.base.model.DeviceProductInfo;
import com.artfess.device.base.model.DeviceProductType;

import java.util.List;

/**
 * 设备产品信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
public interface DeviceProductInfoManager extends BaseManager<DeviceProductInfo> {

    /**
     * 创建产品
     * @param t
     * @return
     */
    String createInfo(DeviceProductInfo t);

    /**
     * 修改产品信息
     * @param t
     * @return
     */
    String updateInfo(DeviceProductInfo t);

    /**
     * 获取产品下拉列表
     * @param productInfo
     * @return
     */
    List<DeviceProductInfo> findAll(DeviceProductInfo productInfo);

    /**
     * 发布产品
     * @param id
     * @return
     */
    boolean publish(String id);

    /**
     * 根据设备id获取设备类型
     * @param deviceId
     * @return
     */
    DeviceProductType findByDeviceId(String deviceId);
}
