package com.artfess.device.base.controller;


import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.device.base.manager.DeviceRelationContractManager;
import com.artfess.device.base.model.DeviceBaseContract;
import com.artfess.device.base.model.DeviceInfo;
import com.artfess.device.base.model.DeviceRelationContract;
import com.artfess.device.base.vo.ContractDeviceVo;
import com.artfess.device.base.vo.ContractVo;
import com.artfess.device.base.vo.DeviceVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

/**
 * 对合同信息进行管理 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-12
 */
@Slf4j
@RestController
@Api(tags = "设施设备-设备合同关联接口")
@RequestMapping("/device/relation/contract/")
@ApiGroup(group = {ApiGroupConsts.DEVICE_BIZ})
public class DeviceRelationContractContractController extends BaseController<DeviceRelationContractManager, DeviceRelationContract> {


    @PostMapping("/bindDevice")
    @ApiOperation("合同关联设备")
    @PowerLogInfo(logType = LogType.BIZ, operaionType = OperationType.ADD, description = "合同关联设备")
    public CommonResult<String> bindDevice(@ApiParam(name="model", value="实体信息") @RequestBody ContractVo t) {
        log.info("关联设备请求参数:{}", JSON.toJSONString(t));
        baseService.bindDevice(t);
        return new CommonResult<>();
    }

    @PostMapping("/getDeviceList")
    @ApiOperation("获取合同已关联设备")
    @PowerLogInfo(logType = LogType.BIZ, operaionType = OperationType.QUERY, description = "获取合同已关联设备")
    public  PageList<ContractDeviceVo> getDeviceList(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter queryFilter) {
        return baseService.getDeviceList(queryFilter);
    }

    @PostMapping(value="/findByPage", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询合同关联设备")
    public PageList<DeviceVo> findByPage(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<DeviceInfo> queryFilter) {
        return baseService.findByPage(queryFilter);
    }

    @PostMapping("/bindContract")
    @ApiOperation("设备关联合同")
    @PowerLogInfo(logType = LogType.BIZ, operaionType = OperationType.ADD, description = "设备关联合同")
    public CommonResult<String> bindContract(@ApiParam(name="model", value="实体信息") @RequestBody DeviceVo t) {
        log.info("设备关联合同请求参数:{}", JSON.toJSONString(t));
        baseService.bindContract(t);
        return new CommonResult<>();
    }

    @PostMapping("/getContractList")
    @ApiOperation("获取设备已关联合同")
    @PowerLogInfo(logType = LogType.BIZ, operaionType = OperationType.QUERY, description = "获取设备已关联合同")
    public CommonResult<String> getContractList(@ApiParam(name="model", value="实体信息") @RequestBody DeviceVo t) {
        log.info("获取设备已关联合同设备请求参数:{}", JSON.toJSONString(t));
        DeviceVo base = baseService.getContractList(t);
        return CommonResult.success(base, "查询成功");
    }

    @PostMapping(value="/findByContractPage", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询设备关联合同")
    public PageList<DeviceBaseContract> findByContractPage(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<DeviceBaseContract> queryFilter) {
        return baseService.findByContractPage(queryFilter);
    }

}
