package com.artfess.device.base.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.device.base.manager.DeviceParamsConfManager;
import com.artfess.device.base.model.DeviceParamsConf;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 设备扩展信息配置 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
@Slf4j
@RestController
@Api(tags = "设施设备-设备扩展信息配置")
@RequestMapping("/device/params/conf/")
@ApiGroup(group = {ApiGroupConsts.DEVICE_BIZ})
public class DeviceParamsConfController extends BaseController<DeviceParamsConfManager, DeviceParamsConf> {

    @PostMapping(value="/findAll", produces={"application/json; charset=utf-8" })
    @ApiOperation("设备扩展信息配置列表（可根据设备id获取，支持参数名称和代码模糊搜索）")
    public List<DeviceParamsConf> findAll(@ApiParam(name="model", value="查询条件") @RequestBody DeviceParamsConf conf) {
        return baseService.findAll(conf);
    }

}
