package com.artfess.device.base.controller;


import com.alibaba.fastjson.JSON;
import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.annotation.PowerLogInfo;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.LogType;
import com.artfess.base.enums.OperationType;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.device.base.manager.DeviceBaseAreaManager;
import com.artfess.device.base.model.DeviceBaseArea;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 设备安装区域信息 例如：XX划片区域-->XX街道-->XX道路-->XX组团-->监测点 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-12
 */

@Slf4j
@RestController
@Api(tags = "设施设备-设备安装区域信息管理")
@RequestMapping("/device/baseArea/")
@ApiGroup(group = {ApiGroupConsts.DEVICE_BIZ})
public class DeviceBaseAreaController extends BaseController<DeviceBaseAreaManager, DeviceBaseArea> {

    @PostMapping("/")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({AddGroup.class}) DeviceBaseArea t) {
        String id = baseService.insertTree(t);
        if(!StringUtils.isNotBlank(id)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

    @PutMapping("/")
    @ApiOperation("更新实体")
    public CommonResult<String> updateById(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({UpdateGroup.class})  DeviceBaseArea t) {
        DeviceBaseArea deviceBaseArea = this.baseService.getById(t.getId());
        String id = baseService.updateTree(t, deviceBaseArea.getName());
        if(!StringUtils.isNotBlank(id)) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新实体失败");
        }
        return new CommonResult<>();
    }

    @PostMapping("/getTree")
    @ApiOperation("获取设备区域下拉树")
    @PowerLogInfo(logType = LogType.BIZ, operaionType = OperationType.QUERY, description = "获取设备区域下拉树")
    public CommonResult<String> getTree(@ApiParam(name = "model", value = "获取设备区域下拉树") @RequestBody DeviceBaseArea entity) {
        log.info("获取设备区域下拉树请求参数:{}", JSON.toJSONString(entity));
        List<DeviceBaseArea> list = baseService.getTree(entity);
        return CommonResult.success(list, null);
    }




}
