package com.artfess.device.base.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.device.base.dao.DeviceBaseParamsConfDao;
import com.artfess.device.base.dao.DeviceBaseParamsValueDao;
import com.artfess.device.base.manager.DeviceBaseParamsConfManager;
import com.artfess.device.base.model.DeviceBaseParamsConf;
import com.artfess.device.base.model.DeviceBaseParamsValue;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

import javax.annotation.Resource;
import java.util.List;

/**
 * 基础扩展信息表 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-19
 */
@Service
public class DeviceBaseParamsConfManagerImpl extends BaseManagerImpl<DeviceBaseParamsConfDao, DeviceBaseParamsConf> implements DeviceBaseParamsConfManager {

    @Resource
    private DeviceBaseParamsValueDao deviceBaseParamsValueDao;

    @Override
    public List<DeviceBaseParamsConf> findAll(DeviceBaseParamsConf conf) {
        QueryWrapper<DeviceBaseParamsConf> queryWrapper = new QueryWrapper();
        if(StringUtils.isNotBlank(conf.getCode())){
            queryWrapper.like("code_", conf.getCode());
        }

        if(StringUtils.isNotBlank(conf.getName())){
            queryWrapper.like("name_", conf.getName());
        }

        if(StringUtils.isNotBlank(conf.getType())){
            queryWrapper.eq("type_", conf.getType());
        }

        queryWrapper.eq("is_dele_", DelStatusEnum.N.getType());
        queryWrapper.orderByAsc("sn_");
        return this.baseMapper.selectList(queryWrapper);
    }

    @Override
    public List<DeviceBaseParamsValue> getConfValue(DeviceBaseParamsValue value) {
        Assert.hasText(value.getBaseId(), "基础信息id不能为空");
        Assert.hasText(value.getType(), "配置类型不能为空");
        QueryWrapper<DeviceBaseParamsValue> queryWrapper = new QueryWrapper();
        queryWrapper.eq("base_id_", value.getBaseId());
        queryWrapper.eq("type_", value.getType());
        return this.deviceBaseParamsValueDao.selectList(queryWrapper);
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public void saveParamsValue(List<DeviceBaseParamsValue> values, String baseId) {
        QueryWrapper<DeviceBaseParamsValue> queryWrapper = new QueryWrapper();
        queryWrapper.eq("base_id_", baseId);
        this.deviceBaseParamsValueDao.delete(queryWrapper);
        if(null == values) {
            return;
        }
        Assert.hasText(baseId, "基础信息id不能为空");
        values.forEach(value -> {
            Assert.hasText(value.getType(), "配置类型不能为空");
            value.setBaseId(baseId);
            this.deviceBaseParamsValueDao.insert(value);
        });

    }
}
