package com.artfess.device.base.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.device.base.manager.AppraiseItemsManager;
import com.artfess.device.base.model.AppraiseItems;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 绩效考核-考核项目信息（DEVICE_APPRAISE_ITEMS） 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author Limuhua
 * @since 2022-08-02
 */
@Slf4j
@RestController
@Api(tags = "绩效考核-考核项信息")
@RequestMapping("/device/appraiseItems/")
@ApiGroup(group = {ApiGroupConsts.DEVICE_BIZ})
public class AppraiseItemsController extends BaseController<AppraiseItemsManager, AppraiseItems> {

}
