/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.material.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.enums.CodePrefix;
import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.manage.material.dao.CmgtMaterialPurchasingDao;
import com.artfess.manage.material.manager.CmgtMaterialPurchasingDetailManager;
import com.artfess.manage.material.manager.CmgtMaterialPurchasingManager;
import com.artfess.manage.material.manager.CmgtMaterialQuantityManage;
import com.artfess.manage.material.model.CmgtMaterialFlowLog;
import com.artfess.manage.material.model.CmgtMaterialPurchasing;
import com.artfess.manage.material.model.CmgtMaterialPurchasingDetail;
import com.artfess.manage.material.model.CmgtMaterialQuantity;
import com.artfess.redis.util.CodeCreatorUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.api.client.util.Lists;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
@Transactional(readOnly=true)
public class CmgtMaterialPurchasingManagerImpl
extends BaseManagerImpl<CmgtMaterialPurchasingDao, CmgtMaterialPurchasing>
implements CmgtMaterialPurchasingManager {
    @Resource
    private CmgtMaterialPurchasingDao cmgtMaterialPurchasingDao;
    @Resource
    private CmgtMaterialPurchasingDetailManager cmgtMaterialPurchasingDetailManager;
    @Autowired
    private CmgtMaterialQuantityManage quantityManage;
    @Resource
    private BaseContext baseContext;
    @Resource
    private CodeCreatorUtil codeCreatorUtil;

    @Override
    @Transactional(readOnly=false)
    public Boolean deleteById(String id) {
        return this.cmgtMaterialPurchasingDao.deleteById(id);
    }

    @Override
    @Transactional
    public String createInfo(CmgtMaterialPurchasing t) {
        t.setStatus("1");
        String code = this.codeCreatorUtil.createCodeYYYYMMDD(CodePrefix.PURCHASING, 12);
        t.setCode(code);
        int i = ((CmgtMaterialPurchasingDao)this.baseMapper).insert((Object)t);
        if (i > 0) {
            this.processDetailList(t);
            return t.getId();
        }
        return null;
    }

    private void processDetailList(CmgtMaterialPurchasing t) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"PURCHASING_ID_", (Object)t.getId());
        this.cmgtMaterialPurchasingDetailManager.remove((Wrapper)queryWrapper);
        if (CollectionUtils.isEmpty(t.getDetailList())) {
            return;
        }
        t.getDetailList().forEach(detail -> detail.setPurchasingId(t.getId()));
        this.cmgtMaterialPurchasingDetailManager.saveOrUpdateBatch(t.getDetailList());
    }

    @Override
    @Transactional
    public String updateInfo(CmgtMaterialPurchasing t) {
        CmgtMaterialPurchasing cmgtMaterialPurchasing = (CmgtMaterialPurchasing)((Object)((CmgtMaterialPurchasingDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == cmgtMaterialPurchasing) {
            throw new BaseException("\u7533\u8bf7\u5355\u4e0d\u5b58\u5728");
        }
        t.setStatus(cmgtMaterialPurchasing.getStatus());
        t.setCode(cmgtMaterialPurchasing.getCode());
        int i = ((CmgtMaterialPurchasingDao)this.baseMapper).updateById((Object)t);
        if (i > 0) {
            this.processDetailList(t);
            return t.getId();
        }
        return null;
    }

    @Override
    public List<CmgtMaterialPurchasingDetail> detailList(List<String> ids) {
        return ((CmgtMaterialPurchasingDao)this.baseMapper).detailList(ids);
    }

    @Override
    @Transactional(readOnly=false)
    public boolean updateStatus(CmgtMaterialPurchasing t) {
        CmgtMaterialPurchasing cmgtMaterialPurchasing = (CmgtMaterialPurchasing)((Object)((CmgtMaterialPurchasingDao)this.baseMapper).selectById((Serializable)((Object)t.getId())));
        if (null == cmgtMaterialPurchasing) {
            return false;
        }
        cmgtMaterialPurchasing.setStatus("2");
        int i = ((CmgtMaterialPurchasingDao)this.baseMapper).updateById((Object)cmgtMaterialPurchasing);
        return i > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean recipients(CmgtMaterialPurchasing t) {
        ArrayList logList = Lists.newArrayList();
        ArrayList quantityList = Lists.newArrayList();
        t.getDetailList().forEach(detail -> this.createLogs(t, logList, quantityList, (CmgtMaterialPurchasingDetail)((Object)detail)));
        t.setStatus("3");
        int i = ((CmgtMaterialPurchasingDao)this.baseMapper).updateById((Object)t);
        return i > 0;
    }

    @Override
    public List<CmgtMaterialPurchasingDetail> recipientsMaterialList(List<String> ids) {
        List<CmgtMaterialPurchasingDetail> cmgtMaterialPurchasingDetails = ((CmgtMaterialPurchasingDao)this.baseMapper).recipientsMaterialList(ids);
        cmgtMaterialPurchasingDetails.forEach(detail -> detail.setAmount(detail.getPrice().multiply(detail.getQuantity())));
        return cmgtMaterialPurchasingDetails;
    }

    private void createLogs(CmgtMaterialPurchasing t, List<CmgtMaterialFlowLog> logList, List<CmgtMaterialQuantity> quantityList, CmgtMaterialPurchasingDetail detail) {
        CmgtMaterialFlowLog log = new CmgtMaterialFlowLog();
        log.setInoutType("2");
        log.setInoutId(t.getId());
        log.setMaterialId(detail.getMaterialInfoId());
        log.setMaterialName(detail.getName());
        log.setModel(detail.getModel());
        log.setUnit(detail.getUnit());
        log.setWarehouse(detail.getWarehouse());
        log.setQuantity(detail.getQuantity());
        log.setForTheDate(LocalDateTime.now());
        log.setFortheOrg(this.baseContext.getCurrentOrgName());
        log.setFortheUser(this.baseContext.getCurrentUserName());
        logList.add(log);
        QueryWrapper quantityQueryWrapper = new QueryWrapper();
        quantityQueryWrapper.eq((Object)"WAREHOUSE_", (Object)detail.getWarehouse());
        quantityQueryWrapper.eq((Object)"material_id_", (Object)detail.getMaterialInfoId());
        CmgtMaterialQuantity cmgtMaterialQuantity = (CmgtMaterialQuantity)((Object)this.quantityManage.getBaseMapper().selectOne((Wrapper)quantityQueryWrapper));
        if (null == cmgtMaterialQuantity) {
            throw new BaseException("\u5f53\u524d\u7269\u8d44\u6682\u65e0\u5e93\u5b58\uff0c\u65e0\u6cd5\u5b8c\u6210\u9886\u7528");
        }
        if (cmgtMaterialQuantity.getQuantity().compareTo(detail.getQuantity()) == -1) {
            throw new BaseException("\u5f53\u524d\u7269\u8d44\u6682\u65e0\u5e93\u5b58\uff0c\u65e0\u6cd5\u5b8c\u6210\u9886\u7528");
        }
        cmgtMaterialQuantity.setQuantity(cmgtMaterialQuantity.getQuantity().subtract(detail.getQuantity()));
        cmgtMaterialQuantity.setAmount(cmgtMaterialQuantity.getAmount().subtract(detail.getAmount()));
        quantityList.add(cmgtMaterialQuantity);
    }
}

