/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.device.monitor.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.enums.ProductTypeEnum;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryField;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.device.base.manager.DeviceInfoManager;
import com.artfess.device.base.manager.DeviceProductInfoManager;
import com.artfess.device.base.manager.DeviceStatusLogManager;
import com.artfess.device.base.model.DeviceInfo;
import com.artfess.device.base.model.DeviceProductType;
import com.artfess.device.base.model.DeviceStatusLog;
import com.artfess.device.base.vo.CountVo;
import com.artfess.device.base.vo.DeviceStatusTimeVo;
import com.artfess.device.base.vo.FailureDeviceCountVo;
import com.artfess.device.monitor.manager.DeviceDataBarricadeManager;
import com.artfess.device.monitor.manager.DeviceDataBarricadeStatusManager;
import com.artfess.device.monitor.manager.DeviceDataHazardManager;
import com.artfess.device.monitor.manager.DeviceDataSignboaerdManager;
import com.artfess.device.monitor.manager.DeviceDataWaterManager;
import com.artfess.device.monitor.model.DeviceDataBarricadeStatus;
import com.artfess.device.monitor.model.DeviceDataHazard;
import com.artfess.device.monitor.model.DeviceDataSignboaerd;
import com.artfess.device.monitor.model.DeviceDataWater;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@Api(tags={"\u8bbe\u65bd\u6570\u636e-\u5b9e\u65f6\u6570\u636e"})
@RequestMapping(value={"/device/data/"})
@ApiGroup(group={"device_biz"})
public class DeviceDataController {
    private static final Logger log = LoggerFactory.getLogger(DeviceDataController.class);
    @Autowired
    private DeviceDataBarricadeManager deviceDataBarricadeManager;
    @Autowired
    private DeviceDataBarricadeStatusManager deviceDataBarricadeStatusManager;
    @Autowired
    private DeviceDataHazardManager deviceDataHazardManager;
    @Autowired
    private DeviceDataSignboaerdManager deviceDataSignboaerdManager;
    @Autowired
    private DeviceDataWaterManager deviceDataWaterManager;
    @Autowired
    private DeviceProductInfoManager deviceProductInfoManager;
    @Autowired
    private DeviceInfoManager deviceInfoManager;
    @Autowired
    private DeviceStatusLogManager deviceStatusLogManager;

    @PostMapping(value={"/query"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u8bbe\u5907\u5b9e\u65f6\u6570\u636e")
    public CommonResult query(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter queryFilter, String id) {
        DeviceProductType productType = this.deviceProductInfoManager.findByDeviceId(id);
        ProductTypeEnum type = ProductTypeEnum.getByType((String)productType.getCode());
        if (null == type) {
            return new CommonResult();
        }
        List querys = queryFilter.getQuerys();
        QueryField queryField = new QueryField();
        queryField.setProperty("device_code_");
        queryField.setValue((Object)productType.getDeviceCode());
        queryField.setOperation(QueryOP.EQUAL);
        querys.add(queryField);
        CommonResult commonResult = new CommonResult();
        switch (type) {
            case barricade: {
                commonResult = this.deviceDataBarricadeStatusManager.findByDeviceId(type.getCode(), (QueryFilter<DeviceDataBarricadeStatus>)queryFilter);
                break;
            }
            case water: {
                commonResult = this.deviceDataWaterManager.findByDeviceId(type.getCode(), (QueryFilter<DeviceDataWater>)queryFilter);
                break;
            }
            case signboaerd: {
                commonResult = this.deviceDataSignboaerdManager.findByDeviceId(type.getCode(), (QueryFilter<DeviceDataSignboaerd>)queryFilter);
                break;
            }
            case hazard: {
                commonResult = this.deviceDataHazardManager.findByDeviceId(type.getCode(), (QueryFilter<DeviceDataHazard>)queryFilter);
                break;
            }
        }
        return commonResult;
    }

    @GetMapping(value={"/statistics/{productType}"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u8bbe\u5907\u7c7b\u578b\u7edf\u8ba1\u5206\u6790")
    public CommonResult statistics(@ApiParam(name="productType", value="\u8bbe\u5907\u7c7b\u578b,\u5347\u964d\u8def\u969c:barricade,\u5371\u9669\u6e90\u76d1\u6d4b:hazard,\u4f4e\u6d3c\u79ef\u6c34\u76d1\u6d4b:water,\u6807\u8bc6\u724c\u76d1\u6d4b:signboaerd") @PathVariable String productType) {
        List<CountVo> data = this.deviceInfoManager.statistics(productType);
        return CommonResult.success(data, (String)"\u7edf\u8ba1\u6210\u529f");
    }

    @PostMapping(value={"/failureStatistics"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6545\u969c\u6b21\u6570\u7edf\u8ba1")
    public CommonResult failureStatistics(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<DeviceInfo> queryFilter) {
        PageList<FailureDeviceCountVo> pageList = this.deviceInfoManager.failureStatistics(queryFilter);
        return CommonResult.success(pageList, null);
    }

    @PostMapping(value={"/timeStatistics"}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u5206\u9875\u83b7\u53d6\u8bbe\u5907\u65f6\u957f\u7edf\u8ba1")
    public CommonResult timeStatistics(@ApiParam(name="queryFilter", value="\u5206\u9875\u67e5\u8be2\u4fe1\u606f") @RequestBody QueryFilter<DeviceStatusLog> queryFilter) {
        PageList<DeviceStatusTimeVo> pageList = this.deviceStatusLogManager.timeStatistics(queryFilter);
        return CommonResult.success(pageList, null);
    }
}

