/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.manage.material.manager.impl;

import com.artfess.base.exception.BaseException;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.manage.material.dao.CmgtMaterialFlowLogDao;
import com.artfess.manage.material.manager.CmgtMaterialFlowLogManager;
import com.artfess.manage.material.manager.CmgtMaterialPurchasingManager;
import com.artfess.manage.material.manager.CmgtMaterialQuantityManage;
import com.artfess.manage.material.model.CmgtMaterialFlowLog;
import com.artfess.manage.material.model.CmgtMaterialPurchasing;
import com.artfess.manage.material.model.CmgtMaterialQuantity;
import com.artfess.manage.material.vo.RecipientsVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
public class CmgtMaterialFlowLogManagerImpl
extends BaseManagerImpl<CmgtMaterialFlowLogDao, CmgtMaterialFlowLog>
implements CmgtMaterialFlowLogManager {
    @Autowired
    private CmgtMaterialPurchasingManager purchasingManager;
    @Autowired
    private CmgtMaterialQuantityManage quantityManage;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean recipients(RecipientsVo t) {
        Assert.hasText((String)t.getPurchasingId(), (String)"\u8bf7\u9009\u62e9\u9886\u7528\u5355");
        CmgtMaterialPurchasing cmgtMaterialPurchasing = (CmgtMaterialPurchasing)this.purchasingManager.get((Serializable)((Object)t.getPurchasingId()));
        Assert.notNull((Object)((Object)cmgtMaterialPurchasing), (String)"\u9886\u7528\u5355\u4e0d\u5b58\u5728");
        if (!"2".equals(cmgtMaterialPurchasing.getApplyType())) {
            throw new BaseException("\u8bf7\u786e\u8ba4\u8be5\u7533\u8bf7\u5355\u662f\u5426\u4e3a\u9886\u7528\u7533\u8bf7\u5355");
        }
        if ("1".equals(cmgtMaterialPurchasing.getStatus()) || "3".equals(cmgtMaterialPurchasing.getStatus())) {
            throw new BaseException("\u8be5\u7533\u8bf7\u5355\u4e0d\u6ee1\u8db3\u9886\u7528\u6761\u4ef6\uff0c\u8bf7\u68c0\u67e5\u7533\u8bf7\u5355\u662f\u5426\u5df2\u786e\u8ba4\u6216\u8005\u5df2\u5b8c\u5168\u51fa\u5e93");
        }
        Assert.notEmpty(t.getList(), (String)"\u8bf7\u9009\u62e9\u8981\u9886\u7528\u7684\u7269\u8d44");
        List<CmgtMaterialFlowLog> list = t.getList();
        ArrayList quantityList = Lists.newArrayList();
        list.forEach(detail -> {
            detail.setInoutType("2");
            detail.setInoutId(t.getPurchasingId());
            detail.setForTheDate(LocalDateTime.now());
            detail.setWarehouse(t.getWarehouse());
            QueryWrapper quantityQueryWrapper = new QueryWrapper();
            quantityQueryWrapper.eq((Object)"WAREHOUSE_", (Object)t.getWarehouse());
            quantityQueryWrapper.eq((Object)"material_id_", (Object)detail.getMaterialId());
            CmgtMaterialQuantity cmgtMaterialQuantity = (CmgtMaterialQuantity)((Object)((Object)this.quantityManage.getBaseMapper().selectOne((Wrapper)quantityQueryWrapper)));
            if (null == cmgtMaterialQuantity || cmgtMaterialQuantity.getQuantity().compareTo(detail.getQuantity()) == -1) {
                throw new BaseException("\u5f53\u524d\u7269\u8d44\u6682\u65e0\u5e93\u5b58\uff0c\u65e0\u6cd5\u5b8c\u6210\u9886\u7528");
            }
            cmgtMaterialQuantity.setQuantity(cmgtMaterialQuantity.getQuantity().subtract(detail.getQuantity()));
            cmgtMaterialQuantity.setAmount(cmgtMaterialQuantity.getAmount().subtract(detail.getAmount()));
            quantityList.add(cmgtMaterialQuantity);
        });
        this.quantityManage.updateBatchById(quantityList);
        this.saveBatch(list);
        return true;
    }
}

