/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.workflow.bpmModel.controller;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.controller.BaseController;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.FieldRelation;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.bpm.persistence.manager.BpmAgentSettingManager;
import com.artfess.bpm.persistence.manager.BpmDefinitionManager;
import com.artfess.bpm.persistence.model.BpmAgentSetting;
import com.artfess.bpm.persistence.model.ResultMessage;
import com.artfess.uc.api.impl.util.ContextUtil;
import com.artfess.uc.api.model.IUser;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/flow/agent/v1/"})
@Api(tags={"\u6d41\u7a0b\u59d4\u6258\u8bbe\u7f6e"})
@ApiGroup(group={"group_bpm"})
public class AgentController
extends BaseController<BpmAgentSettingManager, BpmAgentSetting> {
    @Resource
    BpmDefinitionManager bpmDefinitionManager;

    @RequestMapping(value={"listJson"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6d41\u7a0b\u59d4\u6258\u8bbe\u7f6e\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e", httpMethod="POST", notes="\u6d41\u7a0b\u59d4\u6258\u8bbe\u7f6e\u5217\u8868(\u5206\u9875\u6761\u4ef6\u67e5\u8be2)\u6570\u636e")
    public PageList<BpmAgentSetting> listJson(@ApiParam(name="queryFilter", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestBody QueryFilter<BpmAgentSetting> queryFilter, @ApiParam(name="isMgr", value="\u901a\u7528\u67e5\u8be2\u5bf9\u8c61") @RequestParam Optional<Boolean> isMgr) throws Exception {
        if (!isMgr.orElse(false).booleanValue()) {
            queryFilter.addFilter("auth_id_", (Object)ContextUtil.getCurrentUserId(), QueryOP.EQUAL, FieldRelation.AND, "a");
        }
        PageList bpmAgentSettingList = ((BpmAgentSettingManager)this.baseService).query(queryFilter);
        return bpmAgentSettingList;
    }

    @RequestMapping(value={"agentGet"}, method={RequestMethod.GET}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6839\u636e\u59d4\u6258id\u83b7\u53d6\u59d4\u6258\u4fe1\u606f", httpMethod="GET", notes="\u83b7\u53d6bo\u5b9a\u4e49\u8be6\u60c5")
    public Object get(@ApiParam(name="id", value="\uff0c\u6d41\u7a0b\u59d4\u6258id", required=true) @RequestParam String id) throws Exception {
        BpmAgentSetting bpmAgentSetting = null;
        if (StringUtil.isNotEmpty((String)id)) {
            bpmAgentSetting = ((BpmAgentSettingManager)this.baseService).getById(id);
        }
        return bpmAgentSetting;
    }

    @RequestMapping(value={"save"}, method={RequestMethod.POST}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u4fdd\u5b58\u59d4\u6258\u4fe1\u606f", httpMethod="POST", notes="\u4fdd\u5b58\u59d4\u6258\u4fe1\u606f")
    public CommonResult<String> save(@ApiParam(name="bpmAgentSet", value="\u59d4\u6258\u5bf9\u8c61", required=true) @RequestBody BpmAgentSetting bpmAgentSet) throws Exception {
        String resultMsg = "";
        try {
            BpmAgentSetting bpmAgentSetting = this.getAgentSetting(bpmAgentSet);
            ResultMessage result = ((BpmAgentSettingManager)this.baseService).checkConflict(bpmAgentSetting);
            if (0 == result.getResult()) {
                return new CommonResult(false, result.getMessage(), (Object)"");
            }
            String id = bpmAgentSetting.getId();
            if (StringUtil.isEmpty((String)id)) {
                ((BpmAgentSettingManager)this.baseService).create((Model)bpmAgentSetting);
                resultMsg = "\u6dfb\u52a0\u6d41\u7a0b\u59d4\u6258\u8bbe\u7f6e\u6210\u529f";
            } else {
                ((BpmAgentSettingManager)this.baseService).update((Model)bpmAgentSetting);
                resultMsg = "\u66f4\u65b0\u6d41\u7a0b\u59d4\u6258\u8bbe\u7f6e\u6210\u529f";
            }
            return new CommonResult(true, resultMsg, (Object)"");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new CommonResult(false, e.getMessage(), (Object)"");
        }
    }

    @RequestMapping(value={"remove"}, method={RequestMethod.DELETE}, produces={"application/json; charset=utf-8"})
    @ApiOperation(value="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u7528\u6237\u8bb0\u5f55(\u903b\u8f91\u5220\u9664)", httpMethod="DELETE", notes="\u6279\u91cf\u5220\u9664\u7cfb\u7edf\u7528\u6237\u8bb0\u5f55(\u903b\u8f91\u5220\u9664)")
    public CommonResult<String> remove(@ApiParam(name="ids", value="\u7528\u6237id\u5b57\u7b26\u4e32", required=true) @RequestParam String ids) throws Exception {
        try {
            String[] aryIds = ids.split(",");
            ((BpmAgentSettingManager)this.baseService).removeByIds(aryIds);
            return new CommonResult(true, "\u5220\u9664\u6d41\u7a0b\u59d4\u6258\u8bbe\u7f6e\u6210\u529f", (Object)"");
        }
        catch (Exception e) {
            return new CommonResult(false, "\u5220\u9664\u6d41\u7a0b\u59d4\u6258\u8bbe\u7f6e\u5931\u8d25", (Object)"");
        }
    }

    private BpmAgentSetting getAgentSetting(BpmAgentSetting agentSetting) throws Exception {
        IUser user = ContextUtil.getCurrentUser();
        if (StringUtil.isEmpty((String)agentSetting.getAuthId())) {
            agentSetting.setAuthId(user.getUserId());
            agentSetting.setAuthName(user.getFullname());
        }
        if (StringUtil.isEmpty((String)agentSetting.getAgentId())) {
            agentSetting.setAgentId(user.getUserId());
            agentSetting.setAgent(user.getFullname());
        }
        if (BpmAgentSetting.TYPE_GLOBAL.equals(agentSetting.getType())) {
            agentSetting.getDefList().clear();
            agentSetting.getConditionList().clear();
            agentSetting.setFlowKey(null);
            agentSetting.setFlowName(null);
        } else if (BpmAgentSetting.TYPE_PART.equals(agentSetting.getType())) {
            agentSetting.getConditionList().clear();
            agentSetting.setFlowKey(null);
            agentSetting.setFlowName(null);
        } else if (BpmAgentSetting.TYPE_CONDITION.equals(agentSetting.getType())) {
            agentSetting.getDefList().clear();
            agentSetting.setAgentId(null);
            agentSetting.setAgent(null);
        } else {
            throw new Exception("\u65e0\u6548\u59d4\u6258\u8bbe\u5b9a");
        }
        String id = agentSetting.getId();
        String iGroup = ContextUtil.getCurrentGroupId();
        if (StringUtil.isEmpty((String)id)) {
            agentSetting.setCreateBy(user.getUserId());
        } else {
            agentSetting.setUpdateBy(user.getUserId());
        }
        return agentSetting;
    }
}

