/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.util;

import java.beans.PropertyEditorSupport;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.springframework.util.StringUtils;

public class DateUtils
extends PropertyEditorSupport {
    public static ThreadLocal<SimpleDateFormat> date_sdf = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd");
        }
    };
    public static ThreadLocal<SimpleDateFormat> yyyyMMdd = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyyMMdd");
        }
    };
    public static ThreadLocal<SimpleDateFormat> date_sdf_wz = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
        }
    };
    public static ThreadLocal<SimpleDateFormat> time_sdf = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm");
        }
    };
    public static ThreadLocal<SimpleDateFormat> yyyymmddhhmmss = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyyMMddHHmmss");
        }
    };
    public static ThreadLocal<SimpleDateFormat> short_time_sdf = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("HH:mm");
        }
    };
    public static ThreadLocal<SimpleDateFormat> datetimeFormat = new ThreadLocal<SimpleDateFormat>(){

        @Override
        protected SimpleDateFormat initialValue() {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        }
    };
    private static final long DAY_IN_MILLIS = 86400000L;
    private static final long HOUR_IN_MILLIS = 3600000L;
    private static final long MINUTE_IN_MILLIS = 60000L;
    private static final long SECOND_IN_MILLIS = 1000L;

    private static SimpleDateFormat getSDFormat(String pattern) {
        return new SimpleDateFormat(pattern);
    }

    private static SimpleDateFormat getSDFormat(int type) {
        SimpleDateFormat df = null;
        switch (type) {
            case 1: {
                df = new SimpleDateFormat("yyyy-MM-dd");
                break;
            }
            case 2: {
                df = new SimpleDateFormat("MM/dd/yy");
                break;
            }
            case 3: {
                df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                break;
            }
            case 4: {
                df = new SimpleDateFormat("MM/dd/yyyy");
                break;
            }
            case 5: {
                df = new SimpleDateFormat("yyyyMMddHHmmssS");
                break;
            }
            case 6: {
                df = new SimpleDateFormat("yyyy/MM/dd");
                break;
            }
            case 7: {
                df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5HH\u65f6mm\u5206");
                break;
            }
            case 8: {
                df = new SimpleDateFormat("yyyy\u5e74MM\u6708dd\u65e5");
                break;
            }
            case 9: {
                df = new SimpleDateFormat("yyyy-MM-dd HH:mm");
                break;
            }
            case 10: {
                df = new SimpleDateFormat("HH:mm");
                break;
            }
            case 11: {
                df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSSZ");
                break;
            }
            case 12: {
                df = new SimpleDateFormat("yyyyMMdd_HHmm");
                break;
            }
            default: {
                df = new SimpleDateFormat("yyyy-MM-dd");
            }
        }
        return df;
    }

    public static LocalDateTime timestamToDatetime(long timestamp) {
        Instant instant = Instant.ofEpochMilli(timestamp);
        return LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
    }

    public static long datatimeToTimestamp(LocalDateTime ldt) {
        long timestamp = ldt.toInstant(ZoneOffset.of("+8")).toEpochMilli();
        return timestamp;
    }

    public static Calendar getCalendar() {
        return Calendar.getInstance();
    }

    public static Calendar getCalendar(long millis) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(new Date(millis));
        return cal;
    }

    public static Date getDate() {
        return new Date();
    }

    public static Date getDate(long millis) {
        return new Date(millis);
    }

    public static String timestamptoStr(Timestamp time) {
        Date date = null;
        if (null != time) {
            date = new Date(time.getTime());
        }
        return DateUtils.date2Str(date_sdf.get());
    }

    public static Timestamp str2Timestamp(String str) {
        Date date = DateUtils.str2Date(str, date_sdf.get());
        return new Timestamp(date.getTime());
    }

    public static Date str2Date(String str, SimpleDateFormat sdf) {
        if (null == str || "".equals(str)) {
            return null;
        }
        Date date = null;
        try {
            date = sdf.parse(str);
            return date;
        }
        catch (ParseException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Date str2Date(String str) {
        Date date = DateUtils.str2Date(str, date_sdf.get());
        return date;
    }

    public static Date getDateParse(int type, String str) throws Exception {
        if (str == null || str.equals("")) {
            return null;
        }
        Date date = new Date();
        SimpleDateFormat df = DateUtils.getSDFormat(type);
        date = df.parse(str);
        return date;
    }

    public static String date2Str(SimpleDateFormat date_sdf) {
        Date date = DateUtils.getDate();
        if (null == date) {
            return null;
        }
        return date_sdf.format(date);
    }

    public static String dateformat(String date, String format) {
        SimpleDateFormat sformat = new SimpleDateFormat(format);
        Date _date = null;
        try {
            _date = sformat.parse(date);
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        return sformat.format(_date);
    }

    public static String date2Str(Date date, SimpleDateFormat date_sdf) {
        if (null == date) {
            return null;
        }
        return date_sdf.format(date);
    }

    public static String getDateFormat(int type, Date date) {
        if (date == null) {
            return "";
        }
        SimpleDateFormat df = DateUtils.getSDFormat(type);
        String dateStr = df.format(date);
        return dateStr;
    }

    public static String getDate(String format) {
        Date date = new Date();
        if (null == date) {
            return null;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(format);
        return sdf.format(date);
    }

    public static Timestamp getTimestamp(long millis) {
        return new Timestamp(millis);
    }

    public static Timestamp getTimestamp(String time) {
        return new Timestamp(Long.parseLong(time));
    }

    public static Timestamp getTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static String now() {
        return datetimeFormat.get().format(DateUtils.getCalendar().getTime());
    }

    public static Timestamp getTimestamp(Date date) {
        return new Timestamp(date.getTime());
    }

    public static Timestamp getCalendarTimestamp(Calendar cal) {
        return new Timestamp(cal.getTime().getTime());
    }

    public static Timestamp gettimestamp() {
        Date dt = new Date();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String nowTime = df.format(dt);
        Timestamp buydate = Timestamp.valueOf(nowTime);
        return buydate;
    }

    public static long getMillis() {
        return System.currentTimeMillis();
    }

    public static long getMillis(Calendar cal) {
        return cal.getTime().getTime();
    }

    public static long getMillis(Date date) {
        return date.getTime();
    }

    public static long getMillis(Timestamp ts) {
        return ts.getTime();
    }

    public static String formatDate() {
        return date_sdf.get().format(DateUtils.getCalendar().getTime());
    }

    public static String formatDateTime() {
        return datetimeFormat.get().format(DateUtils.getCalendar().getTime());
    }

    public static String getDataString(SimpleDateFormat formatstr) {
        return formatstr.format(DateUtils.getCalendar().getTime());
    }

    public static String formatDate(Calendar cal) {
        return date_sdf.get().format(cal.getTime());
    }

    public static String formatAddDayDate(int day) {
        Calendar cal = DateUtils.getCalendar();
        cal.add(5, day);
        return date_sdf.get().format(cal.getTime());
    }

    public static String formatSubDayDate(int day) {
        Calendar cal = DateUtils.getCalendar();
        cal.add(5, -day);
        return date_sdf.get().format(cal.getTime());
    }

    public static String formatDate(Date date) {
        return date_sdf.get().format(date);
    }

    public static String formatDate(long millis) {
        return date_sdf.get().format(new Date(millis));
    }

    public static String formatDate(String pattern) {
        return DateUtils.getSDFormat(pattern).format(DateUtils.getCalendar().getTime());
    }

    public static String formatDate(Calendar cal, String pattern) {
        return DateUtils.getSDFormat(pattern).format(cal.getTime());
    }

    public static String formatDate(Date date, String pattern) {
        return DateUtils.getSDFormat(pattern).format(date);
    }

    public static String formatTime() {
        return time_sdf.get().format(DateUtils.getCalendar().getTime());
    }

    public static String formatTime(long millis) {
        return time_sdf.get().format(new Date(millis));
    }

    public static String formatTime(Calendar cal) {
        return time_sdf.get().format(cal.getTime());
    }

    public static String formatTime(Date date) {
        return time_sdf.get().format(date);
    }

    public static String formatShortTime() {
        return short_time_sdf.get().format(DateUtils.getCalendar().getTime());
    }

    public static String formatShortTime(long millis) {
        return short_time_sdf.get().format(new Date(millis));
    }

    public static String formatShortTime(Calendar cal) {
        return short_time_sdf.get().format(cal.getTime());
    }

    public static String formatShortTime(Date date) {
        return short_time_sdf.get().format(date);
    }

    public static Date parseDate(String src, String pattern) throws ParseException {
        return DateUtils.getSDFormat(pattern).parse(src);
    }

    public static Calendar parseCalendar(String src, String pattern) throws ParseException {
        Date date = DateUtils.parseDate(src, pattern);
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        return cal;
    }

    public static String formatAddDate(String src, String pattern, int amount) throws ParseException {
        Calendar cal = DateUtils.parseCalendar(src, pattern);
        cal.add(5, amount);
        return DateUtils.formatDate(cal);
    }

    public static Timestamp parseTimestamp(String src, String pattern) throws ParseException {
        Date date = DateUtils.parseDate(src, pattern);
        return new Timestamp(date.getTime());
    }

    public static int dateDiff(char flag, Calendar calSrc, Calendar calDes) {
        long millisDiff = DateUtils.getMillis(calSrc) - DateUtils.getMillis(calDes);
        if (flag == 'y') {
            return calSrc.get(1) - calDes.get(1);
        }
        if (flag == 'd') {
            return (int)(millisDiff / 86400000L);
        }
        if (flag == 'h') {
            return (int)(millisDiff / 3600000L);
        }
        if (flag == 'm') {
            return (int)(millisDiff / 60000L);
        }
        if (flag == 's') {
            return (int)(millisDiff / 1000L);
        }
        return 0;
    }

    @Override
    public void setAsText(String text) throws IllegalArgumentException {
        if (StringUtils.hasText((String)text)) {
            try {
                if (text.indexOf(":") == -1 && text.length() == 10) {
                    this.setValue(date_sdf.get().parse(text));
                }
                if (text.indexOf(":") > 0 && text.length() == 19) {
                    this.setValue(datetimeFormat.get().parse(text));
                }
                throw new IllegalArgumentException("Could not parse date, date format is error ");
            }
            catch (ParseException ex) {
                IllegalArgumentException iae = new IllegalArgumentException("Could not parse date: " + ex.getMessage());
                iae.initCause(ex);
                throw iae;
            }
        } else {
            this.setValue(null);
        }
    }

    public static int getYear() {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(DateUtils.getDate());
        return calendar.get(1);
    }

    public static void main(String[] args) throws Exception {
        System.out.println(DateUtils.getDateFormat(11, DateUtils.getDate(1649824428766L)));
        System.out.println(DateUtils.getDateFormat(11, DateUtils.getDate(1650356914176L)));
        System.out.println(DateUtils.getDateFormat(11, DateUtils.getDate(1650383999999L)));
    }
}

