/*
 * Decompiled with CFR 0.152.
 */
package com.artfess.base.valid;

import com.artfess.base.enums.DelStatusEnum;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.activerecord.Model;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.xml.bind.ValidationException;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component
public class FieldRepeatUtils {
    private static final Logger log = LoggerFactory.getLogger(FieldRepeatUtils.class);
    private String idColumnName;
    private Object idColumnValue;
    private String DEL = "";

    public boolean fieldRepeat(String[] fields, String message, Object o) throws ValidationException, IllegalAccessException {
        try {
            if (fields != null && fields.length == 0) {
                return true;
            }
            this.checkUpdateOrSave(o);
            this.checkRepeat(fields, o, message);
            return true;
        }
        catch (ValidationException ed) {
            throw new ValidationException(message);
        }
        catch (IllegalAccessException e) {
            throw new IllegalAccessException(e.getMessage());
        }
    }

    public void checkUpdateOrSave(Object o) throws IllegalAccessException {
        Field[] fields;
        for (Field f : fields = FieldRepeatUtils.getAllFields(o.getClass())) {
            f.setAccessible(true);
            if (f.isAnnotationPresent(TableId.class)) {
                TableId tableId = f.getAnnotation(TableId.class);
                this.idColumnName = tableId.value();
                this.idColumnValue = f.get(o);
            }
            if (!f.getName().equals("isDele")) continue;
            this.DEL = f.getName();
        }
    }

    private static Field[] getAllFields(Class<?> clazz) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        while (clazz != null) {
            fieldList.addAll(new ArrayList<Field>(Arrays.asList(clazz.getDeclaredFields())));
            clazz = clazz.getSuperclass();
        }
        Field[] fields = new Field[fieldList.size()];
        return fieldList.toArray(fields);
    }

    public void checkRepeat(String[] fields, Object o, String message) throws ValidationException, IllegalAccessException {
        List list;
        Model model = (Model)o;
        QueryWrapper qw = new QueryWrapper();
        Map<String, Object> queryMap = this.getColumns(fields, o);
        if (CollectionUtils.isEmpty(queryMap)) {
            log.info("\u672a\u914d\u7f6e\u9a8c\u8bc1\u91cd\u590d\u7684\u5b57\u6bb5");
            return;
        }
        qw.and(obj -> {
            int fildNum = 0;
            for (Map.Entry entry : queryMap.entrySet()) {
                if (1 == ++fildNum) {
                    obj.eq(entry.getKey(), entry.getValue());
                    continue;
                }
                ((QueryWrapper)obj.or()).eq(entry.getKey(), entry.getValue());
            }
        });
        if (StringUtils.isNotBlank((CharSequence)this.DEL)) {
            qw.eq((Object)"is_dele_", (Object)DelStatusEnum.N.getType());
        }
        if (this.idColumnValue != null) {
            qw.ne((Object)this.idColumnName, this.idColumnValue);
        }
        if ((list = model.selectList((Wrapper)qw)) != null && list.size() > 0) {
            throw new ValidationException(message);
        }
    }

    public Map<String, Object> getColumns(String[] fields, Object o) throws IllegalAccessException {
        Field[] fieldList = FieldRepeatUtils.getAllFields(o.getClass());
        ConcurrentHashMap<String, Object> map = new ConcurrentHashMap<String, Object>();
        for (Field f : fieldList) {
            f.setAccessible(true);
            if (!ArrayUtils.contains((Object[])fields, (Object)f.getName())) continue;
            this.getMapData(map, f, o);
        }
        return map;
    }

    private void getMapData(Map<String, Object> map, Field f, Object o) throws IllegalAccessException {
        try {
            if (f.isAnnotationPresent(TableField.class)) {
                TableField tableField = f.getAnnotation(TableField.class);
                Object val = f.get(o);
                if (null != val) {
                    map.put(tableField.value(), val);
                }
            }
        }
        catch (IllegalAccessException i) {
            throw new IllegalAccessException("\u83b7\u53d6\u5b57\u6bb5\u7684\u503c\u9519\u8bef");
        }
    }
}

