package com.artfess.manage.material.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.math.BigDecimal;

/**
 * 物资采购领用申请明细
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wujl
 * @since 2022-07-23
 */
@Data
@ApiModel(value="CmgtMaterialPurchasingDetail对象", description="物资采购领用申请明细")
@FieldRepeat(fields = {"name"},message = "品名不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class CmgtMaterialPurchasingDetail extends BaseModel<CmgtMaterialPurchasingDetail> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @NotNull(message = "请选择申请单id",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "申请单id")
    @TableField("PURCHASING_ID_")
    private String purchasingId;

    @ApiModelProperty(value = "物资ID")
    @TableField("MATERIAL_INFO_ID_")
    private String materialInfoId;

    @ApiModelProperty(value = "品名")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "型号")
    @TableField("MODEL_")
    private String model;

    @ApiModelProperty(value = "计量单位")
    @TableField("UNIT_")
    private String unit;

    @ApiModelProperty(value = "申请数量")
    @TableField("QUANTITY_")
    private BigDecimal quantity;

    @ApiModelProperty(value = "描述")
    @TableField("DESCRIPTION_")
    private String description;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "出库库仓库（参考字典）")
    @TableField(exist = false)
    private String warehouse;

    @ApiModelProperty(value = "参考单价")
    @TableField(exist = false)
    private BigDecimal price;

    @ApiModelProperty(value = "单项领用金额")
    @TableField(exist = false)
    private BigDecimal amount;

    @ApiModelProperty(value = "剩余库存")
    @TableField(exist = false)
    private BigDecimal remainingQuantity;

}
