package com.artfess.manage.material.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.math.BigDecimal;
import java.time.LocalDateTime;

/**
 * 物资信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wujl
 * @since 2022-07-23
 */
@Data
@ApiModel(value="CmgtMaterialInfo对象", description="物资信息")
@FieldRepeat(fields = {"code","name"},message = "物资名称或编号不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
public class CmgtMaterialInfo extends AutoFillModel<CmgtMaterialInfo> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @NotNull(message = "必须指定id",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "物资分类ID")
    @TableField("CLASS_ID_")
    private String classId;

    @ApiModelProperty(value = "物资分类名称")
    @TableField("CLASS_NAME_")
    private String className;

    @NotBlank(message = "物资编号",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "物资编号")
    @TableField("CODE_")
    private String code;

    @NotBlank(message = "品名",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "品名")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "规格")
    @TableField("MODEL_")
    private String model;

    @ApiModelProperty(value = "描述")
    @TableField("DESCRIPTION_")
    private String description;

    @ApiModelProperty(value = "厂商")
    @TableField("MANUFACTURER_")
    private String manufacturer;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "备注")
    @TableField("MEMO_")
    private String memo;

    @ApiModelProperty(value = "单位")
    @TableField("UNIT_")
    private String unit;

    @ApiModelProperty(value = "参考单价")
    @TableField("PRICE_")
    private BigDecimal price;

    @TableLogic
    @ApiModelProperty(value = "删除标识，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Integer version;

    @ApiModelProperty(value = "数据时间戳")
    @TableField("LAST_TIME_")
    private LocalDateTime lastTime;

}
