package com.artfess.manage.material.dao;

import com.artfess.manage.material.model.CmgtMaterialQuantity;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import org.apache.ibatis.annotations.Param;
import org.apache.ibatis.annotations.Select;

import java.util.List;
import java.util.Map;

/**
 * @Description: 物资库存
 * @ClassName: CmgtMaterialQuantityDao
 * @Author: wjl
 * @Date: 2022/8/3 11:24
 * @Version: 1.0
 */
public interface CmgtMaterialQuantityDao  extends BaseMapper<CmgtMaterialQuantity>{

    /**
     * 根据物资id和仓库查询当前仓库是否存在该物资
     * @param mid
     * @param warehouse
     * @return
     */
    @Select("select id_ as id,MATERIAL_ID_ as mid," +
            "CLASS_ID_ as classId,MATERIAL_NAME_ as name,WAREHOUSE_ as warehouse,QUANTITY_ quantity " +
            "from CMGT_MATERIAL_QUANTITY where MATERIAL_ID_ = #{mid} and WAREHOUSE_ = #{warehouse} and IS_DELE_ = '0'")
    public CmgtMaterialQuantity findByMidAndWarhouse(@Param("mid") String mid,@Param("warehouse") String warehouse);


    @Select("select w.DATA_TYPE_ as type,d.name_ as name,d.quantity_ as quantity,w.APPLICANT_ applicant,w.INOUT_DATE_ inoutDate " +
            " from cmgt_material_warehouse_inout w,cmgt_material_warehouse_inout_detail d where " +
            "w.ID_ = d.WAREHOUSE_INOUT_ID_ and d.QUANTITY_ID_ = #{qid} and w.IS_DELE_ ='0' and d.IS_DELE_='0'")
    public List<Map<String,Object>> findDetailByquantityId(String qid);

    IPage<CmgtMaterialQuantity> pageQuery(IPage<CmgtMaterialQuantity> convert2IPage,  @Param(Constants.WRAPPER)  QueryWrapper<CmgtMaterialQuantity> convert2Wrapper);
}
