package com.artfess.manage.material.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.i18n.util.I18nUtil;
import com.artfess.manage.material.manager.CmgtMaterialCustomManager;
import com.artfess.manage.material.model.CmgtMaterialCustom;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Arrays;
import java.util.HashMap;

/**
 * 物资供应商信息 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author fanxm
 * @since 2022-08-24
 */
@Slf4j
@Api(tags = "物资管理-供应商信息")
@RestController
@RequestMapping("/manager/cmgtMaterialCustom")
@ApiGroup(group = {ApiGroupConsts.MANAGER_BIZ})
public class CmgtMaterialCustomController extends BaseController<CmgtMaterialCustomManager, CmgtMaterialCustom> {

    @Autowired
    private CmgtMaterialCustomManager cmgtMaterialCustomManager;


    @PostMapping(value="/pageQuery", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询")
    public PageList<CmgtMaterialCustom> pageQuery(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<CmgtMaterialCustom> queryFilter) {
        return cmgtMaterialCustomManager.query(queryFilter);
    }



    @Override
    @PostMapping("/create")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({AddGroup.class}) CmgtMaterialCustom t) {
        if (t.getSn() == null) {
            t.setSn(baseService.getNextSequence(null));
        }
        boolean b = cmgtMaterialCustomManager.updateById(t);
        if (!b) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "创建实体失败");
        }
        return new CommonResult<>();
    }

    @PutMapping("/update")
    @ApiOperation("更新实体的接口")
    public CommonResult<String> update(@ApiParam(name = "model", value = "实体信息") @RequestBody @Validated({UpdateGroup.class}) CmgtMaterialCustom t) {

        if (t.getSn() == null) {
            t.setSn(baseService.getNextSequence(null));
        }
        boolean b = cmgtMaterialCustomManager.updateById(t);
        if (!b) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新实体失败");
        }
        return new CommonResult<>();
    }


    @Override
    @DeleteMapping("/delete")
    @ApiOperation("根据id集合批量删除")
    public CommonResult<String> deleteByIds(@ApiParam(name = "ids", value = "实体集合") @RequestParam String... ids) {
        boolean result =  cmgtMaterialCustomManager.delete(Arrays.asList(ids));
        if (!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
        }
        return new CommonResult<>();
    }

    @Override
    @RequestMapping(value = "updateSequence", method = RequestMethod.POST, produces = {"application/json; charset=utf-8"})
    @ApiOperation(value = "批量修改排序号", notes = "批量修改排序号")
    public CommonResult<String> updateSequence(@ApiParam(name = "params", value = "排序参数：Key：ID，Value：排序号") @RequestBody HashMap<String, Integer> params) throws Exception {
        if(!params.isEmpty()){
            baseService.updateSequence(params);
        }
        return new CommonResult<String>(true, I18nUtil.getMessage("option.success", LocaleContextHolder.getLocale()), null);
    }



}
