package com.artfess.manage.dwd.manager.impl;


import cn.hutool.core.util.ReflectUtil;
import cn.hutool.poi.excel.ExcelUtil;
import cn.hutool.poi.excel.ExcelWriter;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.util.StringUtil;
import com.artfess.manage.base.ManageCommonService;
import com.artfess.manage.dwd.dao.DwdLkEpidemicPreventionInformationDao;
import com.artfess.manage.dwd.manager.DwdLkEpidemicPreventionInformationManager;
import com.artfess.manage.dwd.manager.dto.DwdLkEpidemicPreventionInformationDto;
import com.artfess.manage.dwd.manager.mapper.DwdLkEpidemicPreventionInformationDtoMapper;
import com.artfess.manage.dwd.model.DwdLkEpidemicPreventionInformation;
import com.artfess.manage.utils.ExcelUtils;
import com.artfess.uc.dao.UserDao;
import io.swagger.annotations.ApiModelProperty;
import org.apache.poi.ss.usermodel.CellStyle;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.lang.reflect.Field;
import java.text.ParseException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;
import java.util.stream.Collectors;


/**
 * 防疫信息填写 服务实现类
 *
 * @author yuanhc
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-11-06
 */
@Service
public class DwdLkEpidemicPreventionInformationManagerImpl extends BaseManagerImpl<DwdLkEpidemicPreventionInformationDao, DwdLkEpidemicPreventionInformation> implements DwdLkEpidemicPreventionInformationManager {

    @Resource
    private UserDao userDao;

    @Resource
    private DwdLkEpidemicPreventionInformationDao dwdLkEpidemicPreventionInformationDao;

    @Resource
    private DwdLkEpidemicPreventionInformationDtoMapper dwdLkEpidemicPreventionInformationDtoMapper;

    @Resource
    private ManageCommonService manageCommonService;


    @Override
    public PageList<DwdLkEpidemicPreventionInformationDto> pageQuery(QueryFilter<DwdLkEpidemicPreventionInformation> queryFilter) {
        PageList<DwdLkEpidemicPreventionInformation> result = query(queryFilter);
        PageList<DwdLkEpidemicPreventionInformationDto> r = new PageList<DwdLkEpidemicPreventionInformationDto>(
                result.getRows().stream().map(e -> {
                            DwdLkEpidemicPreventionInformationDto t = dwdLkEpidemicPreventionInformationDtoMapper.toDto(e);


                            return t;
                        }
                ).collect(Collectors.toList())
        );
        r.setTotal(result.getTotal());
        r.setPage(result.getPage());
        r.setPageSize(result.getPageSize());
        return r;
    }

    @Override
    public String createInfo(DwdLkEpidemicPreventionInformation t) {
        int i = this.baseMapper.insert(t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(DwdLkEpidemicPreventionInformation t) {
        this.baseMapper.updateById(t);
        return t.getId();
    }

    @Override
    public void deleteInfo(DwdLkEpidemicPreventionInformation t) {
        this.baseMapper.deleteById(t.getId());
    }


    public String create(DwdLkEpidemicPreventionInformationDto dto) {
        DwdLkEpidemicPreventionInformation t = dwdLkEpidemicPreventionInformationDtoMapper.toEntity(dto);
        int i = this.baseMapper.insert(t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }


    public String update(DwdLkEpidemicPreventionInformationDto dto) {
        DwdLkEpidemicPreventionInformation t = dwdLkEpidemicPreventionInformationDtoMapper.toEntity(dto);
        this.baseMapper.updateById(t);


        return t.getId();
    }

    public boolean delete(List<String> ids) {
        for (String id : ids) {

            int count = this.baseMapper.deleteById(id);
            if (count == 0) {
                return false;
            }
        }
        return true;
    }


    public void export(HttpServletResponse response,
                       QueryFilter<DwdLkEpidemicPreventionInformation> queryFilter) throws ParseException {
        List<DwdLkEpidemicPreventionInformationDto> l = dwdLkEpidemicPreventionInformationDtoMapper.toDto(this.dwdLkEpidemicPreventionInformationDao
                .selectList(convert2Wrapper(queryFilter, DwdLkEpidemicPreventionInformation.class)));

        ExcelWriter writer = ExcelUtil.getWriter();
        org.apache.poi.ss.usermodel.Font font = writer.createFont();
        font.setBold(true);
        CellStyle fsytle = writer.createCellStyle();
        fsytle.setFont(font);
        //writer.getHeadCellStyle().setFont(font);

        Field[] fields = ReflectUtil.getFields(DwdLkEpidemicPreventionInformationDto.class);
        int row = 1;
        for (DwdLkEpidemicPreventionInformationDto informationDto : l) {
            int i = 0;
            for (Field f : fields) {
                ApiModelProperty apiModelProperty = f.getAnnotation(ApiModelProperty.class);
                if (apiModelProperty != null) {
                    if (row == 1) {
                        writer.writeCellValue(i, 0, apiModelProperty.value());
                        if(f.getType().equals(LocalDateTime.class)){
                            writer.setColumnWidth(i,20);
                        }else  if(f.getType().equals(LocalDate.class)){
                            writer.setColumnWidth(i,15);
                        }else  if("mobile".equals(f.getName())){
                            writer.setColumnWidth(i,20);
                        }else  if("idCard".equals(f.getName())){
                            writer.setColumnWidth(i,30);
                        }else{
                            writer.setColumnWidth(i,12);
                        }
                        writer.setStyle( fsytle,i,0);
                    }
                    if(StringUtil.isNotEmpty(apiModelProperty.notes())){
                        writer.writeCellValue(i, row,ReflectUtil.invoke(informationDto,apiModelProperty.notes())).setColumnWidth(i,50);
                    }else{
                        writer.writeCellValue(i, row, ReflectUtil.getFieldValue(informationDto,f));
                    }
                    i++;
                }
            }
            row++;
        }
        //writer.merge(day + 1, arrangeDate + "交巡组排班表");
        //writer.passCurrentRow();
        //浏览器导出
        ExcelUtils.downloadExcel(response, "防疫台帐", writer);
    }

}
