package com.artfess.manage.dwd.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.dwd.manager.DwdLkEpidemicCityManager;
import com.artfess.manage.dwd.manager.dto.DwdLkEpidemicCityDto;
import com.artfess.manage.dwd.model.DwdLkEpidemicCity;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * 风险城市维护 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-11-06
 */
@Slf4j
@Api(tags = "风险城市维护")
@RestController
@RequestMapping("/manager/dwdLkEpidemicCity")
@ApiGroup(group = {ApiGroupConsts.MANAGER_BIZ})
public class DwdLkEpidemicCityController extends BaseController<DwdLkEpidemicCityManager, DwdLkEpidemicCity> {

    @Autowired
    private DwdLkEpidemicCityManager dwdLkEpidemicCityManager;


    @PostMapping(value="/pageQuery", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询")
    public PageList<DwdLkEpidemicCityDto> pageQuery(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<DwdLkEpidemicCity> queryFilter) {
        return dwdLkEpidemicCityManager.pageQuery(queryFilter);
    }

}
