package com.artfess.manage.dingding;

import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.manage.duty.manager.CmgtDutyTeamManager;
import com.artfess.manage.duty.model.CmgtDutyTeam;
import com.artfess.manage.material.manager.CmgtMaterialClassManager;
import com.artfess.manage.material.model.CmgtMaterialClass;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import javax.annotation.Resource;
import java.util.List;

/**
 * 勤务小组信息 前端控制器
 *
 * @author wjl
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-07-20
 */
@Slf4j
@Api(tags = "面向钉钉接口-勤务管理")
@RestController
@RequestMapping("/manager/dingding/material/")
@ApiGroup(group = {ApiGroupConsts.MANAGER_BIZ})
public class CmgtMaterialController extends BaseController<CmgtDutyTeamManager, CmgtDutyTeam> {

    @Resource
    private CmgtMaterialClassManager cmgtMaterialClassManager;

    @GetMapping("/findClass")
    @ApiOperation("查询物资分类")
    public List<CmgtMaterialClass> findClass(String parentId) {
        return cmgtMaterialClassManager.findByParentId(parentId);
    }


}
