package com.artfess.manage.material.model;

import cn.hutool.core.date.DatePattern;
import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 物资出入库单
 *
 * @author wujl
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-07-25
 */
@Data
@ApiModel(value = "CmgtMaterialWarehouseInout对象", description = "物资出入库单")
public class CmgtMaterialWarehouseInout extends AutoFillModel<CmgtMaterialWarehouseInout> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id", groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id", groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    // @NotBlank(message = "出入库标识",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "出入库标识")
    @TableField("DATA_TYPE_")
    private String dataType;//0:入库1：出库

    @ApiModelProperty(value = "仓库")
    @TableField("WAREHOUSE_")
    private String warehouse;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DatePattern.NORM_DATE_PATTERN, timezone = "GMT+8")
    @ApiModelProperty(value = "出入库日期")
    @TableField("INOUT_DATE_")
    private LocalDate inoutDate;

    @ApiModelProperty(value = "供应商")
    @TableField("SOURCE_")
    private String source;

    @ApiModelProperty(value = "描述")
    @TableField("DESCRIPTON_")
    private String descripton;

    @ApiModelProperty(value = "申请人")
    @TableField("APPLICANT_")
    private String applicant;

    @ApiModelProperty(value = "申请人ID")
    @TableField("APPLICANT_ID_")
    private String applicantId;

    @ApiModelProperty(value = "申请人部门")
    @TableField("ORG_")
    private String org;


    @ApiModelProperty(value = "申请人部门ID")
    @TableField("ORG_ID_")
    private String orgId;

    @ApiModelProperty(value = "审核人")
    @TableField("APPROVER_")
    private String approver;

    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(shape = JsonFormat.Shape.STRING, pattern = DatePattern.NORM_DATE_PATTERN, timezone = "GMT+8")
    @ApiModelProperty(value = "审核时间")
    @TableField("APPROVED_DATE_")
    private LocalDate approvedDate;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "备注")
    @TableField("MEMO_")
    private String memo;

    @ApiModelProperty(value = "状态")
    @TableField("STATUS_")
    private String status;


    @TableLogic
    @ApiModelProperty(value = "删除标识，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @TableField(exist = false)
    private List<CmgtMaterialWarehouseInoutDetail> detailList;

//    @ApiModelProperty(value = "创建人")
//    @TableField("CREATE_BY_")
//    private String createBy;
//
//    @ApiModelProperty(value = "创建人机构ID")
//    @TableField("CREATE_ORG_ID_")
//    private String createOrgId;
//
//    @ApiModelProperty(value = "创建时间")
//    @TableField("CREATE_TIME_")
//    private LocalDateTime createTime;
//
//    @ApiModelProperty(value = "修改人员")
//    @TableField("UPDATE_BY_")
//    private String updateBy;
//
//    @ApiModelProperty(value = "修改时间")
//    @TableField("UPDATE_TIME_")
//    private LocalDateTime updateTime;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Integer version;

    @ApiModelProperty(value = "数据时间戳")
    @TableField("LAST_TIME_")
    private LocalDateTime lastTime;

}
