package com.artfess.manage.material.model;

import com.artfess.base.entity.BaseTreeModel;
import com.artfess.base.model.Tree;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.SqlCondition;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.google.common.collect.Lists;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;
import java.util.List;

/**
 * 物资分类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wujl
 * @since 2022-07-21
 */
@Data
@ApiModel(value="CmgtMaterialClass对象", description="物资分类")
public class CmgtMaterialClass extends BaseTreeModel<CmgtMaterialClass> implements Tree {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "描述")
    @TableField("DESCRIPTON_")
    private String descripton;

    @ApiModelProperty(value = "备注")
    @TableField("MEMO_")
    private String memo;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Integer version;

    @ApiModelProperty(value = "数据时间戳")
    @TableField("LAST_TIME_")
    private LocalDateTime lastTime;

    @TableLogic
    @ApiModelProperty(value = "是否已删，1已删除，0未删除")
    @TableField(value = "IS_DELE_", updateStrategy = FieldStrategy.NOT_EMPTY)
    private String isDele;

    @ApiModelProperty(value = "创建人ID", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="create_by_", fill= FieldFill.INSERT, select=false)
    private String createBy;

    @ApiModelProperty(value = "创建时间", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy=FieldStrategy.NOT_NULL,value="create_time_", fill=FieldFill.INSERT, select=true)
    private LocalDateTime createTime;

    @JsonIgnore
    @ApiModelProperty(value = "创建人组织ID", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="create_org_id_", fill= FieldFill.INSERT, select=false)
    private String createOrgId;

    @ApiModelProperty(value = "更新人ID", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="update_by_", fill= FieldFill.UPDATE, select=false)
    private String updateBy;

    @ApiModelProperty(value = "更新时间", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="update_time_", fill= FieldFill.UPDATE, select=false)
    private LocalDateTime updateTime;

    @JsonInclude(JsonInclude.Include.NON_EMPTY)
    @TableField(exist=false)
    protected List<CmgtMaterialClass> children = Lists.newArrayList();

    @Override
    public String getText() {
        return null;
    }

    @Override
    public List getChildren() {
        return this.children;
    }

    @Override
    public void setChildren(List list) {
        this.children = list;
    }

    @Override
    public void setIsParent(String isParent) {
        this.parentId = parentId;
    }

}
