package com.artfess.manage.material.manager.impl;

import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.base.query.QueryOP;
import com.artfess.base.util.StringUtil;
import com.artfess.manage.material.dao.CmgtMaterialClassDao;
import com.artfess.manage.material.dao.CmgtMaterialInfoDao;
import com.artfess.manage.material.manager.CmgtMaterialClassManager;
import com.artfess.manage.material.manager.CmgtMaterialInfoManager;
import com.artfess.manage.material.model.CmgtMaterialInfo;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;

/**
 * 物资信息 服务实现类
 *
 * @author wujl
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-07-23
 */
@Service
public class CmgtMaterialInfoManagerImpl extends BaseManagerImpl<CmgtMaterialInfoDao, CmgtMaterialInfo> implements CmgtMaterialInfoManager {


    @Resource
    CmgtMaterialInfoDao cmgtMaterialInfoDao;


    @Resource
    CmgtMaterialClassDao cmgtMaterialClassDao;

    @Resource
    CmgtMaterialClassManager cmgtMaterialClassManager;

    @Override
    public void create(CmgtMaterialInfo t) {

        if (!StringUtil.isEmpty(t.getClassId())) {
            t.setClassName(cmgtMaterialClassDao.selectById(t.getClassId()).getName());
        } else {
            t.setClassName(null);
        }
        this.save(t);
    }

    @Override
    public void update(CmgtMaterialInfo t) {
        if (!StringUtil.isEmpty(t.getClassId())) {
            t.setClassName(cmgtMaterialClassDao.selectById(t.getClassId()).getName());
        } else {
            t.setClassName(null);
        }
        this.updateById(t);
    }

    @Transactional
    public CmgtMaterialInfo getLikeName(String typeName, String model) {
        QueryWrapper<CmgtMaterialInfo> queryWrapper = new QueryWrapper();
        queryWrapper.eq("NAME_", typeName);
        if (!StringUtil.isEmpty(model)) {
            queryWrapper.like("MODEL_", typeName);
        }
        List<CmgtMaterialInfo> l = cmgtMaterialInfoDao.selectList(queryWrapper);
        if (l.size() > 0) {
            return l.get(0);
        }

        queryWrapper = new QueryWrapper();
        queryWrapper.like("NAME_", typeName);
        if (!StringUtil.isEmpty(model)) {
            queryWrapper.like("MODEL_", typeName);
        }
        l = cmgtMaterialInfoDao.selectList(queryWrapper);
        if (l.size() > 0) {
            return l.get(0);
        }

        queryWrapper = new QueryWrapper();
        queryWrapper.eq("NAME_", typeName);
        l = cmgtMaterialInfoDao.selectList(queryWrapper);
        if (l.size() > 0) {
            return l.get(0);
        }

        return null;
    }


    @Transactional(readOnly = true)
    public PageList<CmgtMaterialInfo> query(QueryFilter<CmgtMaterialInfo> queryFilter) {
//        queryFilter.getQuerys().forEach(
//                q -> {
//                    if ("class_Id_".equals(q.getProperty())) {
//                        q.setOperation(QueryOP.IN);
//                        q.setValue(cmgtMaterialClassManager.findAllChildIds(q.getValue() + ""));
//                    }
//                }
//        );
        PageBean pageBean = queryFilter.getPageBean();
        IPage<CmgtMaterialInfo> result = cmgtMaterialInfoDao.selectPage(convert2IPage(pageBean), convert2Wrapper(queryFilter, CmgtMaterialInfo.class));
        return new PageList<CmgtMaterialInfo>(result);
    }


    /**
     * 查询分类所有物资ID
     *
     * @param classId
     * @return
     */
    public String[] findAllIdsByParentClass(String classId) {
        System.out.println("============classId==============="+classId);
        List<String> l = findAllByParentClass(classId).stream().map(c -> c.getId()).collect(Collectors.toList());
        System.out.println(l.size()+"============xxxxxxxxx==============="+l);
        return l.toArray(new String[]{});
    }

    private List<CmgtMaterialInfo> findAllByParentClass(String classId) {
        QueryWrapper<CmgtMaterialInfo> queryWrapper = new QueryWrapper();
        queryWrapper.in("CLASS_ID_", cmgtMaterialClassManager.findAllChildIds(classId));
        queryWrapper.orderByDesc("create_time_");
        return cmgtMaterialInfoDao.selectList(queryWrapper);
    }


}
