package com.artfess.manage.dwd.manager.dto;

import com.artfess.manage.base.ManageBaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;




/**
 * dwd_sj_weather_forcast_mi
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-21
 */
@Data
@ApiModel(value="DwdSjWeatherForcastMiDto", description="来自互联网心知天气的天气预报DTO对象")
public class DwdSjWeatherForcastMiDto extends ManageBaseModel<DwdSjWeatherForcastMiDto> {


    /** 日期 */
    @ApiModelProperty(value = "日期")
    private String date;




    /** 白天天气现象文字 */
    @ApiModelProperty(value = "白天天气现象文字")
    private String textDay;




    /** 白天天气现象代码 */
    @ApiModelProperty(value = "白天天气现象代码")
    private String codeDay;




    /** 晚间天气现象文字 */
    @ApiModelProperty(value = "晚间天气现象文字")
    private String textNight;




    /** 晚间天气现象代码 */
    @ApiModelProperty(value = "晚间天气现象代码")
    private String codeNight;




    /** 当天最高温度 */
    @ApiModelProperty(value = "当天最高温度")
    private String high;




    /** 当天最低温度 */
    @ApiModelProperty(value = "当天最低温度")
    private String low;




    /** 降水概率，范围0~100，单位百分比（目前仅支持国外城市） */
    @ApiModelProperty(value = "降水概率，范围0~100，单位百分比（目前仅支持国外城市）")
    private String precip;




    /** 风向文字 */
    @ApiModelProperty(value = "风向文字")
    private String windDirection;




    /** 风向角度，范围0~360 */
    @ApiModelProperty(value = "风向角度，范围0~360")
    private String windDirectionDegree;




    /** 风速，单位km/h（当unit=c时）、mph（当unit=f时） */
    @ApiModelProperty(value = "风速，单位km/h（当unit=c时）、mph（当unit=f时）")
    private String windSpeed;




    /** 风力等级 */
    @ApiModelProperty(value = "风力等级")
    private String windScale;




    /** 降水量，单位mm */
    @ApiModelProperty(value = "降水量，单位mm")
    private String rainfall;




    /** 相对湿度，0~100，单位为百分比 */
    @ApiModelProperty(value = "相对湿度，0~100，单位为百分比")
    private String humidity;




    /** 中台插入时间 */
    @ApiModelProperty(value = "中台插入时间")
    private String insertTime;




    @ApiModelProperty(value = "主键_ID")
    private String id;





    private String createByName;

}
