package com.artfess.manage.duty.manager.dto;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.manage.duty.model.CmgtDutyJob;
import com.artfess.manage.duty.model.CmgtDutyTeam;
import com.artfess.uc.model.Org;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;


/**
 * cmgt_duty_team_member
 *
 * @author wujl
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-08-23
 */
@Data
@ApiModel(value = "CmgtDutyTeamMemberDto", description = "勤务队员信息DTO对象")
public class CmgtDutyTeamMemberDto extends AutoFillModel<CmgtDutyTeamMemberDto> {


    /**
     * 主键_ID
     */
    @ApiModelProperty(value = "主键_ID")
    private String id;


    /**
     * 所属小组
     */
    @ApiModelProperty(value = "所属小组")
    private String teamId;

    private CmgtDutyTeam cmgtDutyTeam;


    /**
     * 编号
     */
    @ApiModelProperty(value = "编号")
    private String code;


    /**
     * 姓名
     */
    @ApiModelProperty(value = "姓名")
    private String name;


    /**
     * 职位
     */
    @ApiModelProperty(value = "职位")
    private String post;


    /**
     * 岗位
     */
    @ApiModelProperty(value = "岗位")
    private String job;

    private CmgtDutyJob cmgtDutyJob;

    /**
     * 性别
     */
    @ApiModelProperty(value = "性别")
    private String sex;


    /**
     * 年龄
     */
    @ApiModelProperty(value = "年龄")
    private Integer age;


    /**
     * 联系电话
     */
    @ApiModelProperty(value = "联系电话")
    private String phone;


    /**
     * 身份证号
     */
    @ApiModelProperty(value = "身份证号")
    private String idcard;


    /**
     * 技术情况
     */
    @ApiModelProperty(value = "技术情况")
    private String skill;


    /**
     * 是否外派
     */
    @ApiModelProperty(value = "是否外派")
    private String iswp;


    /**
     * 外派部门名称
     */
    @ApiModelProperty(value = "外派部门名称")
    private String deptName;


    /**
     * 是否正式员工
     */
    @ApiModelProperty(value = "是否正式员工")
    private String iszsyg;


    /**
     * 排序
     */
    @ApiModelProperty(value = "排序")
    private Integer sn;


    /**
     * 备注
     */
    @ApiModelProperty(value = "备注")
    private String memo;


    /**
     * 删除标识，1已删除，0未删除
     */
    @ApiModelProperty(value = "删除标识，1已删除，0未删除")
    private String isDele;


    /**
     * 版本号
     */
    @ApiModelProperty(value = "版本号")
    private Integer version;


    /**
     * 数据时间戳
     */
    @ApiModelProperty(value = "数据时间戳")
    private LocalDateTime lastTime;


    @ApiModelProperty(value = "")
    private String orgId;


    private Org org;


    @ApiModelProperty(value = "实时位置")
    private String location;

    @ApiModelProperty(value = "接收时间")
    private LocalDateTime receiveTime;

    @ApiModelProperty(value = "状态")
    private String status;

}
