package com.artfess.manage.safty.manager.dto;

import com.artfess.manage.base.ManageBaseModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDate;
import java.util.Arrays;
import java.util.stream.Collectors;



/**
 * cmgt_safty_plan_task
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-03
 */
@Data
@ApiModel(value="CmgtSaftyPlanTaskDto", description="安全计划任务DTO对象")
public class CmgtSaftyPlanTaskDto extends ManageBaseModel<CmgtSaftyPlanTaskDto> {


    /** 主键_ID */
    @ApiModelProperty(value = "主键_ID")
    private String id;




    /** 所属计划 */
    @ApiModelProperty(value = "所属计划")
    private String planId;




    /** 任务名称 */
    @ApiModelProperty(value = "任务名称")
    private String name;




    /** 任务日期 */
    @ApiModelProperty(value = "任务日期")
    private LocalDate taskDate;




    /** 工作描述 */
    @ApiModelProperty(value = "工作描述")
    private String description;




    /** 依据 */
    @ApiModelProperty(value = "依据")
    private String according;




    /** 责任人 */
    @ApiModelProperty(value = "责任人")
    private String taskUser;

    public void setTaskUserValues(String[] t) {
        if (t != null) {
            this.taskUser= Arrays.asList(t).stream().collect(Collectors.joining(","));
        } else {
            this.taskUser= null;
        }
    }

    public String[] getTaskUserValues() {
        if (this.taskUser != null) {
            return this.taskUser.split(",");
        } else {
            return new String[]{};
        }
    }



    /** 排序 */
    @ApiModelProperty(value = "排序")
    private Integer sn;




    /** 备注 */
    @ApiModelProperty(value = "备注")
    private String memo;





    private String createByName;

}
