package com.artfess.manage.safty.manager.dto;

import com.artfess.base.entity.AutoFillModel;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.time.LocalDateTime;


/**
 * cmgt_safty_danger_unit
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wujl
 * @since 2022-08-01
 */
@Data
@ApiModel(value="CmgtSaftyDangerUnitDto", description="安全隐患排查对象DTO对象")
public class CmgtSaftyDangerUnitDto extends AutoFillModel<CmgtSaftyDangerUnitDto> {

    /** 主键_ID */
    @ApiModelProperty(value = "主键_ID")
    private String id;


    /** 对象名称 */
    @ApiModelProperty(value = "对象名称")
    private String unitName;


    /** 经营人姓名 */
    @ApiModelProperty(value = "经营人姓名")
    private String name;


    /** 经营人电话 */
    @ApiModelProperty(value = "经营人电话")
    private String phone;


    /** 地址 */
    @ApiModelProperty(value = "地址")
    private String address;


    /** 面积 */
    @ApiModelProperty(value = "面积")
    private Double area;


    /** 从业人数 */
    @ApiModelProperty(value = "从业人数")
    private Integer personNum;


    /** 类别 */
    @ApiModelProperty(value = "类别")
    private String type;


    /** 是否三合一 */
    @ApiModelProperty(value = "是否三合一")
    private String isShy;

    private String licenseNumber;

    /** 安全隐患 */
    @ApiModelProperty(value = "安全隐患")
    private String content;


    /** 风险级别 */
    @ApiModelProperty(value = "风险级别")
    private String level;


    /** 排序 */
    @ApiModelProperty(value = "排序")
    private Integer sn;


    /** 备注 */
    @ApiModelProperty(value = "备注")
    private String memo;


    /** 删除标识，1已删除，0未删除 */
    @ApiModelProperty(value = "删除标识，1已删除，0未删除")
    private String isDele;



    /** 版本号 */
    @ApiModelProperty(value = "版本号")
    private Integer version;


    /** 数据时间戳 */
    @ApiModelProperty(value = "数据时间戳")
    private LocalDateTime lastTime;



}
