package com.artfess.manage.safty.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.safty.manager.CmgtSaftyDangerCheckplanManager;
import com.artfess.manage.safty.manager.CmgtSaftyDangerUnitManager;
import com.artfess.manage.safty.manager.dto.CmgtSaftyDangerCheckplanDto;
import com.artfess.manage.safty.model.CmgtSaftyDangerCheckplan;
import com.artfess.manage.safty.model.CmgtSaftyDangerUnit;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 安全隐患排查计划 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wujl
 * @since 2022-08-01
 */
@Slf4j
@Api(tags = "安全隐患排查计划")
@RestController
@RequestMapping("/manager/cmgtSaftyDangerCheckplan")
@ApiGroup(group = {ApiGroupConsts.MANAGER_BIZ})
public class CmgtSaftyDangerCheckplanController extends BaseController<CmgtSaftyDangerCheckplanManager, CmgtSaftyDangerCheckplan> {

    @Autowired
    private CmgtSaftyDangerCheckplanManager cmgtSaftyDangerCheckplanManager;

    @Autowired
    private CmgtSaftyDangerUnitManager dangerUnitManager;

    @PostMapping(value="/pageQuery", produces={"application/json; charset=utf-8" })
    @ApiOperation("分页查询")
    public PageList<CmgtSaftyDangerCheckplanDto> pageQuery(@ApiParam(name="queryFilter", value="分页查询信息") @RequestBody QueryFilter<CmgtSaftyDangerCheckplan> queryFilter) {
        return cmgtSaftyDangerCheckplanManager.pageQuery(queryFilter);
    }

    /**
     *
     * @return
     */
    @PostMapping(value="/findAllUnit", produces={"application/json; charset=utf-8" })
    @ApiOperation("获取所有隐患单位信息")
    public List<CmgtSaftyDangerUnit> findAllUnit(){
       return dangerUnitManager.getAll();
    }


}
