package com.artfess.manage.material.model;

import com.artfess.base.entity.AutoFillModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableLogic;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;

/**
 * 物资出入库明细
 *
 * @author wujl
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-07-25
 */
@Data
@ApiModel(value = "CmgtMaterialWarehouseInoutDetail对象", description = "物资出入库明细")
public class CmgtMaterialWarehouseInoutDetail extends AutoFillModel<CmgtMaterialWarehouseInoutDetail> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id", groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id", groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @NotNull(message = "新增、修改必须指定id", groups = {AddGroup.class, UpdateGroup.class})
    @ApiModelProperty(value = "出入库ID")
    @TableField("WAREHOUSE_INOUT_ID_")
    private String warehouseInoutId;

    @ApiModelProperty(value = "物资ID")
    @TableField("MATERIAL_INFO_ID_")
    private String materialInfoId;

    @ApiModelProperty(value = "库存标识")
    @TableField("QUANTITY_ID_")
    private String quantityId;

    @ApiModelProperty(value = "品名")
    @TableField("NAME_")
    private String name;

    @ApiModelProperty(value = "单位")
    @TableField("UNIT_")
    private String unit;

    @ApiModelProperty(value = "规格型号")
    @TableField("MODEL_")
    private String model;

    @ApiModelProperty(value = "数量")
    @TableField("QUANTITY_")
    private BigDecimal quantity;

    @ApiModelProperty(value = "可用数量")
    @TableField("AVAILABLE_QUANTITY_")
    private BigDecimal availableQuantity;

    @ApiModelProperty(value = "单价")
    @TableField("PRICE_")
    private BigDecimal price;

    @ApiModelProperty(value = "总价")
    @TableField("AMOUNT_")
    private BigDecimal amount;

    @ApiModelProperty(value = "供应商")
    @TableField("SUPPLIER_")
    private String supplier;

    @ApiModelProperty(value = "描述")
    @TableField("DESCRIPTION_")
    private String description;

    @ApiModelProperty(value = "排序")
    @TableField("SN_")
    private Integer sn;

    @ApiModelProperty(value = "备注")
    @TableField("MEMO_")
    private String memo;

    @ApiModelProperty(value = "申请人部门ID")
    @TableField("ORG_ID_")
    private String orgId;

    @ApiModelProperty(value = "仓库")
    @TableField("WAREHOUSE_")
    private String warehouse;

    @ApiModelProperty(value = "申请人")
    @TableField("APPLICANT_")
    private String applicant;

    @ApiModelProperty(value = "申请人ID")
    @TableField("APPLICANT_ID_")
    private String applicantId;

    @ApiModelProperty(value = "出入库日期")
    @TableField("INOUT_DATE_")
    private LocalDate inoutDate;

    @ApiModelProperty(value = "状态")
    @TableField("STATUS_")
    private String status;

    @TableLogic
    @ApiModelProperty(value = "删除标识，1已删除，0未删除")
    @TableField("IS_DELE_")
    private String isDele;

    @ApiModelProperty(value = "版本号")
    @TableField("VERSION_")
    private Integer version;

    @ApiModelProperty(value = "数据时间戳")
    @TableField("LAST_TIME_")
    private LocalDateTime lastTime;


}
