package com.artfess.manage.material.manager.impl;

import com.artfess.base.context.BaseContext;
import com.artfess.base.enums.CodePrefix;
import com.artfess.base.exception.BaseException;
import com.artfess.manage.material.dao.CmgtMaterialUsedDetailDao;
import com.artfess.manage.material.manager.CmgtMaterialFlowLogManager;
import com.artfess.manage.material.manager.CmgtMaterialOrderManager;
import com.artfess.manage.material.manager.CmgtMaterialQuantityManage;
import com.artfess.manage.material.manager.CmgtMaterialSignWarehouseDetailManager;
import com.artfess.manage.material.manager.CmgtMaterialUsedDetailManager;
import com.artfess.manage.material.model.CmgtMaterialFlowLog;
import com.artfess.manage.material.model.CmgtMaterialOrder;
import com.artfess.manage.material.model.CmgtMaterialOrderDetail;
import com.artfess.manage.material.model.CmgtMaterialOrderSupplier;
import com.artfess.manage.material.model.CmgtMaterialPurchasing;
import com.artfess.manage.material.model.CmgtMaterialQuantity;
import com.artfess.manage.material.model.CmgtMaterialSignWarehouse;
import com.artfess.manage.material.dao.CmgtMaterialSignWarehouseDao;
import com.artfess.manage.material.manager.CmgtMaterialSignWarehouseManager;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.manage.material.model.CmgtMaterialSignWarehouseDetail;
import com.artfess.manage.material.model.CmgtMaterialUsedDetail;
import com.artfess.redis.util.CodeCreatorUtil;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.google.api.client.util.Lists;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import javax.annotation.Resource;
import java.time.LocalDateTime;
import java.util.List;

/**
 * 订单物资到货签收入库表 服务实现类
 *
 * @author min.wu
 * @company 阿特菲斯信息技术有限公司
 * @since 2023-04-24
 */
@Service
public class CmgtMaterialSignWarehouseManagerImpl extends BaseManagerImpl<CmgtMaterialSignWarehouseDao, CmgtMaterialSignWarehouse> implements CmgtMaterialSignWarehouseManager {

    @Resource
    private BaseContext baseContext;

    @Autowired
    private CmgtMaterialSignWarehouseDetailManager signWarehouseDetailManager;

    @Resource
    private CmgtMaterialUsedDetailManager usedDetailManager;

    @Resource
    private CmgtMaterialFlowLogManager flowLogManager;

    @Autowired
    private CmgtMaterialQuantityManage quantityManage;

    @Autowired
    private CmgtMaterialOrderManager orderManager;
    @Resource
    private CodeCreatorUtil codeCreatorUtil;


    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean saveInfo(CmgtMaterialSignWarehouse t) {
        String code = codeCreatorUtil.createCodeYYYYMMDD(CodePrefix.SIGN_WAREHOUSE, 12);
        t.setCode(code);
        int insert = this.baseMapper.insert(t);
        if (insert > 0) {
            processDetailList(t);
            return true;
        }

        return false;
    }

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean updateInfo(CmgtMaterialSignWarehouse t) {
        CmgtMaterialSignWarehouse warehouse = baseMapper.selectById(t.getId());
        if (null == warehouse) {
            throw new BaseException("申请单不存在");
        }
        t.setCode(warehouse.getCode());
        t.setStatus(warehouse.getStatus());
        int insert = this.baseMapper.updateById(t);
        if (insert > 0) {
            processDetailList(t);
            return true;
        }
        return false;
    }

    @Override
    public CmgtMaterialSignWarehouse findById(String id) {
        CmgtMaterialSignWarehouse cmgtMaterialSignWarehouse = this.baseMapper.selectById(id);
        if (null == cmgtMaterialSignWarehouse) {
            return new CmgtMaterialSignWarehouse();
        }
        QueryWrapper<CmgtMaterialSignWarehouseDetail> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("sign_warehouse_id_", id);
        List<CmgtMaterialSignWarehouseDetail> cmgtMaterialSignWarehouseDetails = signWarehouseDetailManager.getBaseMapper().selectList(queryWrapper);
        cmgtMaterialSignWarehouse.setDetailList(cmgtMaterialSignWarehouseDetails);
        return cmgtMaterialSignWarehouse;
    }

    private void processDetailList(CmgtMaterialSignWarehouse t) {
        QueryWrapper<CmgtMaterialSignWarehouseDetail> queryWrapper = new QueryWrapper<>();
        queryWrapper.eq("sign_warehouse_id_", t.getId());
        this.signWarehouseDetailManager.remove(queryWrapper);

        if (CollectionUtils.isEmpty(t.getDetailList())) {
            return;
        }

        //删除常用物资
        QueryWrapper<CmgtMaterialUsedDetail> usedQuery = new QueryWrapper<>();
        usedQuery.eq("create_org_id_", baseContext.getCurrentOrgId());
        usedDetailManager.remove(usedQuery);
        List<CmgtMaterialUsedDetail> usedDetails = Lists.newArrayList();
        List<CmgtMaterialFlowLog> logList = Lists.newArrayList();
        List<CmgtMaterialQuantity> quantityList = Lists.newArrayList();
        t.getDetailList().forEach(detail -> {
            detail.setSignWarehouseId(t.getId());
            createLogs(t, logList, quantityList, detail);
            createUsedMaterial(usedDetails, detail);

        });
        signWarehouseDetailManager.saveOrUpdateBatch(t.getDetailList());
        usedDetailManager.saveBatch(usedDetails);
        flowLogManager.saveBatch(logList);
        quantityManage.saveOrUpdateBatch(quantityList);
        //更新采购订单状态以及记录完成时间
        if ("2".equals(t.getStatus())) {
            CmgtMaterialOrder cmgtMaterialOrder = orderManager.get(t.getOrderId());
            if (null != cmgtMaterialOrder) {
                cmgtMaterialOrder.setStatus("2");
                cmgtMaterialOrder.setCompleteDate(LocalDateTime.now());
                orderManager.update(cmgtMaterialOrder);
            }
        }
    }

    private void createLogs(CmgtMaterialSignWarehouse t,
                            List<CmgtMaterialFlowLog> logList,
                            List<CmgtMaterialQuantity> quantityList,
                            CmgtMaterialSignWarehouseDetail detail) {
        if ("2".equals(t.getStatus())) {
            //1、更新库存 2、记录入库日志
            CmgtMaterialFlowLog log = new CmgtMaterialFlowLog();
            log.setInoutType("1");
            log.setInoutId(t.getId());
            log.setMaterialId(detail.getMaterialId());
            log.setMaterialName(detail.getName());
            log.setModel(detail.getModel());
            log.setUnit(detail.getUnit());
            log.setWarehouse(t.getWarehouse());
            log.setQuantity(detail.getQuantity());
            log.setForTheDate(LocalDateTime.now());
            log.setFortheOrg(baseContext.getCurrentOrgName());
            log.setFortheUser(baseContext.getCurrentUserName());
            logList.add(log);

            QueryWrapper<CmgtMaterialQuantity> quantityQueryWrapper = new QueryWrapper<>();
            quantityQueryWrapper.eq("WAREHOUSE_", t.getWarehouse());
            quantityQueryWrapper.eq("material_id_", detail.getMaterialId());
            CmgtMaterialQuantity cmgtMaterialQuantity = this.quantityManage.getBaseMapper().selectOne(quantityQueryWrapper);
            if (null == cmgtMaterialQuantity) {
                cmgtMaterialQuantity = new CmgtMaterialQuantity();
                cmgtMaterialQuantity.setWarehouse(t.getWarehouse());
                cmgtMaterialQuantity.setMid(detail.getMaterialId());
                cmgtMaterialQuantity.setModel(detail.getModel());
                cmgtMaterialQuantity.setUnit(detail.getUnit());
                cmgtMaterialQuantity.setQuantity(detail.getQuantity());
                cmgtMaterialQuantity.setAmount(detail.getAmount());
            } else {
                cmgtMaterialQuantity.setQuantity(cmgtMaterialQuantity.getQuantity().add(detail.getQuantity()));
                cmgtMaterialQuantity.setAmount(cmgtMaterialQuantity.getAmount().add(detail.getAmount()));
            }
            quantityList.add(cmgtMaterialQuantity);
        }
    }

    private void createUsedMaterial(List<CmgtMaterialUsedDetail> usedDetails, CmgtMaterialSignWarehouseDetail detail) {
        CmgtMaterialUsedDetail cmgtMaterialUsedDetail = new CmgtMaterialUsedDetail();
        cmgtMaterialUsedDetail.setMaterialId(detail.getMaterialId());
        cmgtMaterialUsedDetail.setModel(detail.getModel());
        cmgtMaterialUsedDetail.setUnit(detail.getUnit());
        cmgtMaterialUsedDetail.setSn(detail.getSn());
        usedDetails.add(cmgtMaterialUsedDetail);
    }
}
