package com.artfess.manage.material.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageBean;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.material.dao.CmgtMaterialQuantityDao;
import com.artfess.manage.material.manager.CmgtMaterialQuantityManage;
import com.artfess.manage.material.model.CmgtMaterialQuantity;
import com.baomidou.mybatisplus.core.metadata.IPage;
import org.springframework.stereotype.Service;

import java.math.BigDecimal;
import java.util.List;


/**
 * 物资库存信息 服务实现类
 *
 * @author fanxm
 * @company 阿特菲斯信息技术有限公司
 * @since 2022-09-02
 */
@Service
public class CmgtMaterialQuantityManageImpl extends BaseManagerImpl<CmgtMaterialQuantityDao, CmgtMaterialQuantity> implements CmgtMaterialQuantityManage {

    @Override
    public PageList<CmgtMaterialQuantity> pageQuery(QueryFilter<CmgtMaterialQuantity> queryFilter) {


        PageBean pageBean = queryFilter.getPageBean();
        Class<CmgtMaterialQuantity> currentModelClass = currentModelClass();
        IPage<CmgtMaterialQuantity> result = baseMapper.pageQuery(convert2IPage(pageBean), convert2Wrapper(queryFilter, currentModelClass));
        result.getRecords().forEach(detail-> {
            if(null == detail.getQuantity()) {
                detail.setQuantity(BigDecimal.ZERO);
            }
            if(null == detail.getPrice()) {
                detail.setPrice(BigDecimal.ZERO);
            }
            detail.setAmount(detail.getQuantity().multiply(detail.getPrice()));
        });
        return new PageList<CmgtMaterialQuantity>(result);
    }

    @Override
    public void deleteInfo(CmgtMaterialQuantity t) {
        this.baseMapper.deleteById(t.getId());
    }


    @Override
    public boolean delete(List<String> ids) {
        for (String id : ids) {

            int count = this.baseMapper.deleteById(id);
            if (count == 0) {
                return false;
            }
        }
        return true;
    }


}
