package com.artfess.manage.material.controller;


import com.artfess.base.annotation.ApiGroup;
import com.artfess.base.constants.ApiGroupConsts;
import com.artfess.base.controller.BaseController;
import com.artfess.base.enums.ResponseErrorEnums;
import com.artfess.base.model.CommonResult;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.manage.material.manager.CmgtMaterialQuantityManage;
import com.artfess.manage.material.manager.CmgtMaterialWarehouseInoutDetailManager;
import com.artfess.manage.material.manager.CmgtMaterialWarehouseInoutManager;
import com.artfess.manage.material.model.CmgtMaterialWarehouseInout;
import com.artfess.manage.material.model.CmgtMaterialWarehouseInoutDetail;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.math.BigDecimal;
import java.util.List;


/**
 * 物资出库单 前端控制器
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wujl
 * @since 2022-07-25
 */
@Slf4j
@RestController
@RequestMapping("/manager/material/out/warehouse/")
@ApiGroup(group = {ApiGroupConsts.MANAGER_BIZ})
public class CmgtMaterialWarehouseOutController extends BaseController<CmgtMaterialWarehouseInoutManager, CmgtMaterialWarehouseInout> {
    @Autowired
    private CmgtMaterialWarehouseInoutDetailManager warehouseInoutDetailManager;

    @Autowired
    private CmgtMaterialWarehouseInoutManager warehouseInoutManager;

    @Autowired
    private CmgtMaterialQuantityManage quantityManage;



    @PostMapping("/add")
    @ApiOperation("添加实体的接口")
    public CommonResult<String> create(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({AddGroup.class}) CmgtMaterialWarehouseInout t) {
        //判断出库物资数量是否小于等于库存
        for(CmgtMaterialWarehouseInoutDetail d:t.getDetailList()){
            if(d.getDescription()!=null){
                //库存数小于领用数
                int flag = quantityManage.getById(d.getDescription()).getQuantity().compareTo(d.getQuantity());
                System.out.println("----------------flag----------"+flag);
                if(flag < 0 ){
                    return new CommonResult<>("-011", d.getName()+"库存不足");
                }
            }
        }
        t.setDataType("1");
        boolean result = warehouseInoutManager.createInout(t);
        if(!result) {
           return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, null);
        }
        return new CommonResult<>();
    }

    @PostMapping("/getDetailList")
    @ApiOperation("获取出库单下所有物资明细")
    public CommonResult<String> getDetailList(@RequestBody String oid){
        List<CmgtMaterialWarehouseInoutDetail> list = warehouseInoutDetailManager.findMaterialDetailById(oid);
        return CommonResult.success(list, null);
    }

    @PutMapping("/update")
    @ApiOperation("更新实体")
    public CommonResult<String> updateById(@ApiParam(name="model", value="实体信息") @RequestBody @Validated({UpdateGroup.class}) CmgtMaterialWarehouseInout t) {
//       //判断出库物资数量是否小于等于库存
        for(CmgtMaterialWarehouseInoutDetail d:t.getDetailList()){
            if(d.getMaterialInfoId()!=null){
                //库存数小于领用数
                BigDecimal flag = warehouseInoutManager.getQuantity(t.getId(),d.getQuantityId(),d.getQuantity());
                System.out.println("----------------flag----------"+flag);
                if(flag!=null && flag.compareTo(new BigDecimal(0)) < 0){
                    return new CommonResult<>("-011", d.getName()+"库存不足");
                }
            }
        }
        boolean result = warehouseInoutManager.updateInout(t);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "更新实体失败");
        }
        return new CommonResult<>();
    }


    @DeleteMapping("/delete")
    @ApiOperation("根据id集合批量删除")
    public CommonResult<String> deleteByIds(@ApiParam(name="ids", value="实体集合") @RequestParam String...ids) {
        boolean result = warehouseInoutManager.removeInoutById(ids);
        if(!result) {
            return new CommonResult<>(ResponseErrorEnums.FAIL_OPTION, "删除实体失败");
        }
        return new CommonResult<>();
    }


}
