package com.artfess.manage.dwd.model;

import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.UpdateGroup;
import com.artfess.manage.base.ManageBaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;

/**
 * dwd_sj_festival_holiday
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-10-07
 */
@Data
@ApiModel(value="DwdSjFestivalHoliday对象", description="生活服务-节假日信息")
//@FieldRepeat(fields = {"code","name"},message = "名称不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
@TableName(value = "dwd_sj_festival_holiday")
public class DwdSjFestivalHoliday extends ManageBaseModel<DwdSjFestivalHoliday> {


    /** 主键_ID */
    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "主键_ID")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    /** 日期 */
    @ApiModelProperty(value = "日期")
    @TableField("vacation_date_")
    private String vacationDate;

    /** 假期 */
    @ApiModelProperty(value = "假期")
    @TableField("holiday_")
    private String holiday;

    /** 假期名称 */
    @ApiModelProperty(value = "假期名称")
    @TableField("name_")
    private String name;

    /** 说明 */
    @ApiModelProperty(value = "说明")
    @TableField("tip_")
    private String tip;

    /** 其他 */
    @ApiModelProperty(value = "其他")
    @TableField("rest_")
    private String rest;

    /** 全部内容 */
    @ApiModelProperty(value = "全部内容")
    @TableField("content_")
    private String content;

    /** 排序 */
    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    /** 备注 */
    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

}
