package com.artfess.manage.dwd.manager.impl;


import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.base.ManageCommonService;
import com.artfess.manage.dwd.dao.DwdSjStationArrivedDao;
import com.artfess.manage.dwd.manager.DwdSjStationArrivedManager;
import com.artfess.manage.dwd.manager.dto.DwdSjStationArrivedDto;
import com.artfess.manage.dwd.manager.mapper.DwdSjStationArrivedDtoMapper;
import com.artfess.manage.dwd.model.DwdSjStationArrived;
import com.artfess.uc.dao.UserDao;
import com.artfess.uc.model.User;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.List;
import java.util.stream.Collectors;



/**
 * 国铁重庆北站-历史到达人数 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author yuanhc
 * @since 2022-09-27
 */
@Service
public class DwdSjStationArrivedManagerImpl extends BaseManagerImpl<DwdSjStationArrivedDao, DwdSjStationArrived> implements DwdSjStationArrivedManager {

    @Resource
    private UserDao userDao;

    @Resource
    private DwdSjStationArrivedDao dwdSjStationArrivedDao;

    @Resource
    private DwdSjStationArrivedDtoMapper dwdSjStationArrivedDtoMapper ;

    @Resource
    private ManageCommonService manageCommonService;


    @Override
    public PageList<DwdSjStationArrivedDto> pageQuery(QueryFilter<DwdSjStationArrived> queryFilter) {
        PageList<DwdSjStationArrived> result = query(queryFilter);
        PageList<DwdSjStationArrivedDto> r = new PageList<DwdSjStationArrivedDto>(
                result.getRows().stream().map(e -> {
                            DwdSjStationArrivedDto t = dwdSjStationArrivedDtoMapper.toDto(e);


                            if(e.getCreateBy()!=null){
                               User user = userDao.selectById(e.getCreateBy());
                               if(user!=null){
                                   t.setCreateByName(user.getFullname());
                               }
                            }

                            return t;
                        }
                ).collect(Collectors.toList())
        );
        r.setTotal(result.getTotal());
        r.setPage(result.getPage());
        r.setPageSize(result.getPageSize());
        return r;
    }

    @Override
    public String createInfo(DwdSjStationArrived t) {
        int i = this.baseMapper.insert(t);
        if(i>0){
            return t.getId();
        }
        return null;
    }

    @Override
    public String updateInfo(DwdSjStationArrived t) {
        this.baseMapper.updateById(t);
        return t.getId();
    }

    @Override
    public void deleteInfo(DwdSjStationArrived t) {
        this.baseMapper.deleteById(t.getId());
    }


    public String create(DwdSjStationArrivedDto dto) {
        DwdSjStationArrived t = dwdSjStationArrivedDtoMapper.toEntity(dto);
        int i = this.baseMapper.insert(t);
        if (i > 0) {
            return t.getId();
        }
        return null;
    }


    public String update(DwdSjStationArrivedDto dto) {
        DwdSjStationArrived t = dwdSjStationArrivedDtoMapper.toEntity(dto);
        this.baseMapper.updateById(t);


        return t.getId();
    }

    public boolean delete(List<String> ids) {
        for (String id : ids) {

            int count = this.baseMapper.deleteById(id);
            if (count == 0) {
                return false;
            }
        }
        return true;
    }




}
