package com.artfess.manage.duty.manager;


import com.artfess.base.manager.BaseManager;
import com.artfess.base.query.PageList;
import com.artfess.base.query.QueryFilter;
import com.artfess.manage.duty.manager.dto.CmgtDutyOrgWorkarrangeDto;
import com.artfess.manage.duty.model.CmgtDutyOrgWorkarrange;

import java.util.List;
import java.util.Map;

/**
 * 部门排班信息 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author wujl
 * @since 2022-08-11
 */
public interface CmgtDutyOrgWorkarrangeManager extends BaseManager<CmgtDutyOrgWorkarrange> {

    /**
     * 条件分页查询
     * @param queryFilter
     * @return
     */
    PageList<CmgtDutyOrgWorkarrangeDto> pageQuery(QueryFilter<CmgtDutyOrgWorkarrange> queryFilter);

    /**
     * 新增
     * @param t
     * @return
     */
    String createInfo(CmgtDutyOrgWorkarrange t);

    /**
     * 更新
     * @param t
     * @return
     */
    String updateInfo(CmgtDutyOrgWorkarrange t);

    /**
     * 删除
     * @param t
     */
    void deleteInfo(CmgtDutyOrgWorkarrange t);


    String create(CmgtDutyOrgWorkarrangeDto dto);

    String update(CmgtDutyOrgWorkarrangeDto dto);

    boolean delete(List<String> ids);

    /**
     * 获取所有组织树信息
     * @return
     */
    public List<Map<String, Object>> getAllOrgTree();

    /**
     * 获取所有排班表信息
     * @return
     */
    public List<CmgtDutyOrgWorkarrange> findAll();

}
