package com.artfess.device.monitor.manager;

import com.artfess.base.manager.BaseManager;
import com.artfess.base.model.CommonResult;
import com.artfess.base.query.QueryFilter;
import com.artfess.device.base.dto.StatisticsDto;
import com.artfess.device.monitor.model.DeviceDataWater;
import com.artfess.device.monitor.vo.WaterStatisticVo;

/**
 * 实时监控-水位监控（DEVICE_DATA_WATER） 服务类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author chens
 * @since 2022-07-26
 */
public interface DeviceDataWaterManager extends BaseManager<DeviceDataWater> {

    CommonResult findByDeviceId(String type,  QueryFilter<DeviceDataWater> queryFilter);

    WaterStatisticVo statistic(StatisticsDto dto);
}
