package com.artfess.device.base.vo;

import com.artfess.device.base.model.DeviceBaseContract;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 设备分组关联vo
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-18
 */
@Data
@ApiModel(value="设备vo")
public class DeviceVo {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键_ID")
    private String id;

    @ApiModelProperty(value = "设备ID")
    private String deviceId;

    @ApiModelProperty(value = "产品_ID")
    private String productId;

    @ApiModelProperty(value = "产品名称")
    private String productName;

    @ApiModelProperty(value = "产品分类")
    private String typeName;

    @ApiModelProperty(value = "设备标识")
    private String code;

    @ApiModelProperty(value = "设备名称")
    private String name;

    @ApiModelProperty(value = "设备管理人员")
    private String managerUserName;

    @ApiModelProperty(value = "供应商")
    private String supplierCompanyName;

    @ApiModelProperty(value = "合同列表")
    private List<DeviceBaseContract> contracts;

}
