package com.artfess.device.base.model;

import com.artfess.base.entity.BaseModel;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;

import java.io.Serializable;

/**
 * 供应商合同关联表
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
@ApiModel(value="DeviceRelationSupplierContract对象", description="供应商合同关联表")
public class DeviceRelationSupplierContract extends BaseModel<DeviceRelationSupplierContract> {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @ApiModelProperty(value = "单位ID")
    @TableField("COMPANY_ID_")
    private String companyId;

    @ApiModelProperty(value = "合同ID")
    @TableField("CONTRACT_ID_")
    private String contractId;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId;
    }

    public String getContractId() {
        return contractId;
    }

    public void setContractId(String contractId) {
        this.contractId = contractId;
    }


    @Override
    protected Serializable pkVal() {
        return this.id;
    }

    @Override
    public String toString() {
        return "DeviceRelationSupplierContract{" +
            "id=" + id +
            ", companyId=" + companyId +
            ", contractId=" + contractId +
        "}";
    }
}
