package com.artfess.device.base.model;

import com.artfess.base.entity.BaseModel;
import com.artfess.base.valid.AddGroup;
import com.artfess.base.valid.FieldRepeat;
import com.artfess.base.valid.UpdateGroup;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.fasterxml.jackson.annotation.JsonIgnore;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Null;
import java.time.LocalDateTime;

/**
 * 设备分组信息
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
@Data
@FieldRepeat(fields = {"groupCode","groupName"},message = "分组名称或标识不能重复，请重新输入",groups = {AddGroup.class, UpdateGroup.class})
@ApiModel(value="DeviceGroupInfo对象", description="设备分组信息")
public class DeviceGroupInfo extends BaseModel<DeviceGroupInfo> {

    private static final long serialVersionUID = 1L;

    @NotNull(message = "修改必须指定id",groups = {UpdateGroup.class})
    @Null(message = "新增不能指定id",groups = {AddGroup.class})
    @ApiModelProperty(value = "id")
    @TableId(value = "ID_", type = IdType.ASSIGN_ID)
    private String id;

    @NotBlank(message = "请填写分组标识",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "分组标识")
    @TableField("group_code_")
    private String groupCode;

    @NotBlank(message = "请填写分组名称",groups = {AddGroup.class,UpdateGroup.class})
    @ApiModelProperty(value = "分组名称")
    @TableField("group_name_")
    private String groupName;

    @ApiModelProperty(value = "排序")
    @TableField("sn_")
    private Integer sn;

    @ApiModelProperty(value = "备注")
    @TableField("memo_")
    private String memo;

    @ApiModelProperty(value = "版本号")
    @TableField("version_")
    private Integer version;

    @JsonIgnore
    @ApiModelProperty(value = "数据时间戳", hidden=true, accessMode= ApiModelProperty.AccessMode.READ_ONLY)
    @TableField(updateStrategy= FieldStrategy.NOT_NULL,value="last_time_", fill= FieldFill.INSERT_UPDATE, select=false)
    private LocalDateTime lastTime;

}
