package com.artfess.device.base.manager.impl;

import com.artfess.base.enums.DelStatusEnum;
import com.artfess.base.manager.impl.BaseManagerImpl;
import com.artfess.device.base.dao.DeviceProductParamsConfDao;
import com.artfess.device.base.manager.DeviceProductParamsConfManager;
import com.artfess.device.base.model.DeviceProductParamsConf;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * 产品扩展信息配置 服务实现类
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
@Service
public class DeviceProductParamsConfManagerImpl extends BaseManagerImpl<DeviceProductParamsConfDao, DeviceProductParamsConf> implements DeviceProductParamsConfManager {

    @Override
    public List<DeviceProductParamsConf> findAll(DeviceProductParamsConf conf) {

        QueryWrapper<DeviceProductParamsConf> queryWrapper = new QueryWrapper();
        if(StringUtils.isNotBlank(conf.getCode())){
            queryWrapper.like("code_", conf.getCode());
        }

        if(StringUtils.isNotBlank(conf.getName())){
            queryWrapper.like("name_", conf.getName());
        }

        if(StringUtils.isNotBlank(conf.getProductId())){
            queryWrapper.like("product_id_", conf.getProductId());
        }

        queryWrapper.eq("is_dele_", DelStatusEnum.N.getType());
        queryWrapper.orderByAsc("sn_");
        return this.baseMapper.selectList(queryWrapper);
    }

    @Override
    public void vaild(DeviceProductParamsConf t) {
        QueryWrapper<DeviceProductParamsConf> queryWrapper = new QueryWrapper();
        if(StringUtils.isNotBlank(t.getId())) {
            queryWrapper.ne("id_", t.getId());
        }
        queryWrapper.eq("code_", t.getCode()).eq("product_id_",t.getProductId());
        List<DeviceProductParamsConf> deviceProductParamsConfs = this.baseMapper.selectList(queryWrapper);
        if(!CollectionUtils.isEmpty(deviceProductParamsConfs)) {
            throw new IllegalArgumentException("参数标识已重复，请重新输入");
        }
        queryWrapper = new QueryWrapper();
        if(StringUtils.isNotBlank(t.getId())) {
            queryWrapper.ne("id_", t.getId());
        }
        queryWrapper.eq("name_", t.getName()).eq("product_id_",t.getProductId());

        deviceProductParamsConfs = this.baseMapper.selectList(queryWrapper);
        if(!CollectionUtils.isEmpty(deviceProductParamsConfs)) {
            throw new IllegalArgumentException("参数名称已重复，请重新输入");
        }

    }
}
