package com.artfess.device.base.dao;

import com.artfess.device.base.model.DeviceBaseContract;
import com.artfess.device.base.model.DeviceInfo;
import com.artfess.device.base.model.DeviceRelationContract;
import com.artfess.device.base.vo.ContractDeviceVo;
import com.artfess.device.base.vo.DeviceVo;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Constants;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;

/**
 * 设备合同关联表 Mapper 接口
 *
 * @company 阿特菲斯信息技术有限公司
 * @author min.wu
 * @since 2022-07-15
 */
public interface DeviceRelationContractDao extends BaseMapper<DeviceRelationContract> {

    /**
     * 根据合同id获取设备列表
     *
     * @return
     */
    IPage<ContractDeviceVo> getDeviceList(Page page, @Param("vo") Map<String, Object> params);

    IPage<DeviceVo> queryPage(IPage<DeviceRelationContract> convert2IPage, @Param(Constants.WRAPPER) Wrapper<DeviceRelationContract> convert2Wrapper);

    IPage<DeviceBaseContract> findByContractPage(IPage<DeviceRelationContract> convert2IPage, @Param(Constants.WRAPPER) Wrapper<DeviceRelationContract> convert2Wrapper);
}
